/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.rubrique.util;

import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public class RubriqueManager {

	private static final Logger LOG = LoggerFactory.getLogger(RubriqueManager.class);

	public static void deleteRubrique(final OMContext ctx, final InfosRubriques infosRubriques, final boolean deleteContent, final boolean recursif) throws Exception {
		if (infosRubriques == null) {
			return;
		}
		LOG.info("Requête rubrique : code=" + infosRubriques.getCode() + " libelle=" + infosRubriques.getIntitule());
		// suppression du contenu
		if (deleteContent && infosRubriques.getCode() != null) {
			final Metatag meta = new Metatag();
			meta.setCtx(ctx);
			meta.init();
			final ClauseWhere where = new ClauseWhere();
			where.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_RUBRIQUE", infosRubriques.getCode()));
			if (meta.select(where.formaterSQL()) > 0) {
				while (meta.nextItem()) {
					final FicheUniv ficheUniv = FicheUnivMgr.init(meta);
					ficheUniv.setCtx(ctx);
					ficheUniv.setIdFiche(meta.getMetaIdFiche());
					try {
						ficheUniv.retrieve();
						FicheUnivMgr.supprimerFiche(ficheUniv, true);
						LOG.info("Suppression fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
					} catch (final Exception e) {
						LOG.info("Erreur suppression fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
					}
				}
			}
		}
		// suppression des sous rubriques
		if (recursif) {
			final Collection<InfosRubriques> lstSousRubriques = infosRubriques.getListeSousRubriques();
			if (lstSousRubriques.size() > 0) {
				for (final InfosRubriques infosSousRubriques : lstSousRubriques) {
					deleteRubrique(ctx, infosSousRubriques, deleteContent, recursif);
				}
			}
		}
		// suppression de la rubrique
		final Rubrique rubrique = new Rubrique();
		rubrique.setCtx(ctx);
		rubrique.init();
		rubrique.setIdRubrique(infosRubriques.getIdRubrique());
		rubrique.retrieve();
		rubrique.delete();
		LOG.info("Suppression rubrique : code=" + infosRubriques.getCode() + " libelle=" + infosRubriques.getIntitule());
	}

	public static void changeRedacteur(final OMContext ctx, final InfosRubriques infosRubriques, final String oldCode, final String newCode, final boolean recursif)
		throws Exception {
		if (infosRubriques == null || infosRubriques.getCode() == null || oldCode == null || newCode == null) {
			LOG.info("Changement de redacteur impossible avec ces parametres : oldcode = " + oldCode + " newCode = " + newCode + " infosRubriques " + infosRubriques);
			return;
		}
		LOG.info("Requête rubrique : code=" + infosRubriques.getCode() + " libelle=" + infosRubriques.getIntitule());
		// suppression du contenu
		final Metatag meta = new Metatag();
		meta.setCtx(ctx);
		meta.init();
		final ClauseWhere where = new ClauseWhere();
		where.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_RUBRIQUE", infosRubriques.getCode()));
		where.and(ConditionHelper.egalVarchar("META_CODE_REDACTEUR", oldCode));
		if (meta.select(where.formaterSQL()) > 0) {
			while (meta.nextItem()) {
				final FicheUniv ficheUniv = FicheUnivMgr.init(meta);
				ficheUniv.setCtx(ctx);
				ficheUniv.setIdFiche(meta.getMetaIdFiche());
				try {
					ficheUniv.retrieve();
					ficheUniv.setCodeRedacteur(newCode);
					ficheUniv.setCodeValidation(newCode);
					ficheUniv.update();
					LOG.info("Mise à jour fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
				} catch (final Exception e) {
					LOG.info("Erreur mise à jour fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
				}
			}
		}
		// mise à jour des sous rubriques
		if (recursif) {
			final Collection<InfosRubriques> lstSousRubriques = infosRubriques.getListeSousRubriques();
			if (lstSousRubriques.size() > 0) {
				for (final InfosRubriques infosSousRubriques : lstSousRubriques) {
					changeRedacteur(ctx, infosSousRubriques, oldCode, newCode, recursif);
				}
			}
		}
	}
}
