/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.rubrique.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;

/**
 * Source de rubriques
 * 
 * @author emmanuel clisson
 */
public abstract class RubriqueProvider {

	/**
	 * Donne une map de rubriques. Toutes les rubriques sont accessibles par leur code et sont rangées dans la liste des enfants des autres rubriques (suppression des cycles). les
	 * rubriques possèdent l'observateur isRoot pour faciliter les traitements. is
	 * 
	 * @param file
	 * @return une map
	 * @throws FileNotFoundException
	 */
	public abstract Map<String, RubriqueWrapper> setRubrique(File file) throws Exception;
}
