/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.rubrique.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriqueReader {

	public static Logger logger = LoggerFactory.getLogger(RubriqueReader.class);

	public RubriqueProvider provider = null;

	public RubriqueReader(RubriqueProvider rubriqueProvider) {
		this.provider = rubriqueProvider;
	}

	public RubriqueProvider getProvider() {
		return provider;
	}

	public void setProvider(RubriqueProvider provider) {
		this.provider = provider;
	}

	/**
	 * Instancie des rubriques K-Portal
	 * 
	 * @param paths
	 *            : fichier source
	 * @return une map des rubriques trouvées (c.f. RubriqueProvider)
	 */
	public Map<String, RubriqueWrapper> read(String paths) {
		logger.info("---> lecture : chemins = " + paths);
		Map<String, RubriqueWrapper> rubriques = null;
		if (provider == null) {
			logger.error("- problème de lecture : provider null (extension de fichier non reconnue)");
		} else {
			if (paths != null && !"".equals(paths.trim())) {
				paths = paths.trim();
				StringTokenizer pathTokenizer = new StringTokenizer(paths, ";");
				if (pathTokenizer.hasMoreElements()) {
					String path = pathTokenizer.nextToken().trim();
					if (path != null && !"".equals(path)) {
						logger.info("> parcours du chemin : " + path);
						File file = new File(path);
						if (!file.exists()) {
							logger.info("- chemin inexistant");
						} else if (!file.canRead()) {
							logger.info("- pas de droits de lecture sur ce chemin");
						} else if (file.isHidden()) {
							logger.info("- chemin caché : données ignorées");
						} else {
							if (file.isFile()) {
								logger.info("- le chemin correspond à un fichier");
								try {
									rubriques = provider.setRubrique(file);
									if (rubriques == null) {
										logger.info("- impossible de parser le fichier");
									} else {
										logger.info("- parsing ok");
									}
								} catch (FileNotFoundException e) {
									logger.info("- problème lors de la lecture du fichier (fichier non trouvé) : " + e.getMessage());
								} catch (Exception e) {
									logger.info("- problème lors de la lecture du fichier :" + e.getMessage());
								}
							} else if (file.isDirectory()) {
								logger.info("- le chemin correspond à un répertoire : on ne fait rien");
							} else {
								logger.info("- chemin de type inconnu");
							}
						}
						logger.info("< chemin parcouru : " + path);
					}
				}
			}
		}
		logger.info("<--- fin de lecture : " + ((rubriques == null) ? "0" : rubriques.size()) + " rubriques traitées");
		return rubriques;
	}
}
