/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.scheduling.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.scheduling.bean.JobParameter;

public class SchedulerManagerHelper {

	private static final String DEFAULT_NAME_TRIGGER = "Trigger";

	private static final String DEFAULT_NAME_JOB = "Sequence";

	public static SchedulerManager getSchedulerManager() {
		return (SchedulerManager) ApplicationContextManager.getCoreContextBean(SchedulerManager.ID_BEAN);
	}

	public static boolean isJobActif(JobKey jobKey) {
		return getSchedulerManager().isJobActif(jobKey);
	}

	public static String getJobNameFromTrigger(String triggerName) {
		return StringUtils.replace(triggerName, DEFAULT_NAME_TRIGGER, DEFAULT_NAME_JOB);
	}

	public static String getTriggerName(Long idSequenceTrigger) {
		return idSequenceTrigger + DEFAULT_NAME_TRIGGER;
	}

	public static IJobModule getModuleForJob(String jobName) {
		final Map<String, IJobModule> modules = getSchedulerManager().getJobModules();
		return modules.get(jobName);
	}

	/**
	 * Récupère la liste de tous les jobs
	 */
	public static Map<JobKey, JobDetail> getAllJobs() {
		return getSchedulerManager().getJobDetails();
	}

	/**
	 * Récupère les détails d'un job donné
	 */
	public static JobDetail getJob(final String idJob) {
		final JobKey job = new JobKey(idJob);
		return getAllJobs().get(job);
	}

	/**
	 * Récupère la liste des paramètres pour un job donné
	 */
	public static List<JobParameter> getParametersForJob(final String idJob) {
		final List<JobParameter> params = new ArrayList<JobParameter>();
		final JobDetail details = getJob(idJob);
		final JobDataMap jdm = details.getJobDataMap();
		for (final String key : jdm.keySet()) {
			final JobParameter param = new JobParameter(key, jdm.get(key));
			params.add(param);
		}
		return params;
	}
}
