/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.scheduling.monitoring.impl.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;

public class BatchExecutionDateHelper extends JobListenerSupport {

	private static final String NAME = "BatchExecutionDateHelper";

	private final Map<String, Date> jobNamesAndLastExecutionDate = Collections.synchronizedMap(new HashMap<String, Date>());

	@Override
	public String getName() {
		return NAME;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.quartz.listeners.JobListenerSupport#jobWasExecuted(org.quartz.
	 * JobExecutionContext, org.quartz.JobExecutionException)
	 */
	@Override
	public void jobWasExecuted(final JobExecutionContext context, JobExecutionException jobException) {
		jobNamesAndLastExecutionDate.put(
			BatchExecutionDateHelper.getJobLastExecutionDateKey(context.getJobDetail().getKey().getName(), context.getJobDetail().getKey().getGroup()), new Date());
	}

	public Date getJobLastExecutionDate(final String jobName, final String groupName) {
		return jobNamesAndLastExecutionDate.get(BatchExecutionDateHelper.getJobLastExecutionDateKey(jobName, groupName));
	}

	private static String getJobLastExecutionDateKey(String jobName, String groupName) {
		StringBuffer buf = new StringBuffer();
		buf.append(jobName);
		if (groupName != null) {
			buf.append(groupName);
		}
		return buf.toString();
	}
}
