/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.scheduling.monitoring.impl.quartz;

import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.Trigger.CompletedExecutionInstruction;
import org.quartz.TriggerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTriggerListener implements TriggerListener {

	private static final Logger LOGGER = LoggerFactory.getLogger(BatchTriggerListener.class);

	public static final String NO_RESUME_AFTER_COMPLETE = "noResumeAfterComplete";

	private Boolean pause = false;

	@Override
	public String getName() {
		return "batchTriggerListener";
	}

	@Override
	public void triggerFired(Trigger trigger, JobExecutionContext context) {
		// TODO Auto-generated method stub
	}

	@Override
	public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
		try {
			synchronized (pause) {
				// on met en pause tous les triggers existants
				if (!pause) {
					context.getScheduler().pauseAll();
					pause = true;
				}
				return false;
			}
		} catch (SchedulerException e) {
			LOGGER.error(e.getMessage(), e);
		}
		LOGGER.warn("veto sur l'execution du JOB : impossible mettre en pause les triggers");
		return true;
	}

	@Override
	public void triggerMisfired(Trigger trigger) {
		// TODO Auto-generated method stub
	}

	@Override
	public void triggerComplete(Trigger trigger, JobExecutionContext context, CompletedExecutionInstruction triggerInstructionCode) {
		try {
			synchronized (pause) {
				boolean noResume = context.getMergedJobDataMap().getBooleanValue(NO_RESUME_AFTER_COMPLETE);
				if (pause && !noResume) {
					context.getScheduler().resumeAll();
					pause = false;
				}
			}
		} catch (SchedulerException e) {
			LOGGER.error(e.getMessage(), e);
		}
	}
}
