/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.scheduling.service;

import java.util.Map;

import com.kportal.scheduling.spring.quartz.SequenceJobDetailDecorator;

public interface SequenceTrigger {

	static final int ETAT_NON_ACTIF = 0;

	static final int ETAT_ACTIF = 1;

	static final int TYPE_NON_PARAMETRABLE_NON_AFFICHABLE = -1;

	static final int TYPE_NON_PARAMETRABLE_AFFICHABLE = 0;

	static final int TYPE_PARAMETRABLE_NON_SUPPRIMABLE = 1;

	static final int TYPE_PARAMETRABLE_SUPPRIMABLE = 2;

	public String getCronExpression();

	public Map<String, SequenceJobDetailDecorator> getSequence();

	public Integer getEtat();

	public Integer getType();

	public String getDescription();
}
