/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.scheduling.service;

import java.util.HashMap;
import java.util.Map;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.extension.ExtensionHelper;

public class SequenceTriggerServiceImpl implements SequenceTriggerService {

	@Override
	public Map<String, SequenceTrigger> getSequenceTriggers() {
		final Map<String, SequenceTrigger> res = new HashMap<String, SequenceTrigger>();
		for (final String idCtx : ExtensionHelper.getExtensionManager().getExtensions().keySet()) {
			final Map<String, SequenceTrigger> map = ApplicationContextManager.getBeansOfType(idCtx, SequenceTrigger.class);
			for (final String key : map.keySet()) {
				if (map.get(key).getEtat() == SequenceTrigger.ETAT_ACTIF) {
					res.put(key, map.get(key));
				}
			}
		}
		return res;
	}

	@Override
	public void init() {
		// TODO Auto-generated method stub
	}
}
