/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.scheduling.spring.quartz;

import java.net.InetAddress;
import java.util.UUID;

import org.quartz.SchedulerException;
import org.quartz.spi.InstanceIdGenerator;

public class SimpleInstanceIdGenerator implements InstanceIdGenerator {

	@Override
	public String generateInstanceId() throws SchedulerException {
		try {
			return InetAddress.getLocalHost().getHostName() + UUID.randomUUID();
		} catch (Exception e) {
			throw new SchedulerException("Couldn't get host name!", e);
		}
	}
}
