/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * This class wraps a HttpServletResponse with a buffered output. You can use this to forward or include a Servlet or JSP page and capture the output from it.
 * 
 * Use getOutput to get the output which was written to the response. Only buffers the Writer. Not the OutputStream !!
 * 
 */
public class BufferedHttpResponseWrapper extends HttpServletResponseWrapper {

	PrintWriter writer = null;

	ByteArrayOutputStream baos = null;

	/**
	 * Constructor for BufferedHttpResponseWrapper. Create a new buffered Writer
	 * 
	 * @param response
	 *            The response object to wrap
	 */
	public BufferedHttpResponseWrapper(HttpServletResponse response) {
		super(response);
		baos = new ByteArrayOutputStream();
		writer = new PrintWriter(baos);
	}

	/**
	 * Return the buffered Writer
	 * 
	 * @see javax.servlet.ServletResponse#getWriter()
	 */
	@Override
	public PrintWriter getWriter() throws IOException {
		return writer;
	}

	/**
	 * Return the output written to the Writer. To get the output, the Writer must be flushed and closed. The content is captured by the ByteArrayOutputStream.
	 * 
	 * @return
	 */
	public String getOutput() {
		writer.flush();
		writer.close();
		return baos.toString();
	}
}
