/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;

@WebServlet(name = "servletRedirectProfil", urlPatterns = "/servlet/com.kportal.servlet.ServletRedirectProfil", loadOnStartup = 0)
public class ServletRedirectProfil extends ExtensionServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = 294149678142598381L;

	@Override
	protected void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
		// Initialisation du contexte (infos utilisateur, connexion BdD,...)
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		final String urlRedirect = ctx.getInfosSite().getJspFo() + "/error/404.jsp";
		String urlAccueilProfil = "";
		final String codeProfil = request.getParameter("code");
		if (codeProfil != null && ctx.getListeProfilsDsi().contains(codeProfil)) {
			urlAccueilProfil = UnivWebFmt.getUrlAccueilDsi(ctx) + "&amp;PROFIL=" + codeProfil;
		}
		if (StringUtils.isNotBlank(urlAccueilProfil)) {
			urlAccueilProfil = EscapeString.unescapeHtml(urlAccueilProfil);
			response.sendRedirect(URLResolver.getAbsoluteUrl(urlAccueilProfil, ctx));
		} else {
			getServletContext().getRequestDispatcher(urlRedirect).forward(request, response);
		}
	}
}
