/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.site.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;

/**
 * 
 * * @author yacouba.kone
 * 
 */
public class SiteUtil {

	/**
	 * Methode renvoyant une Hashtable contenant les couples(Code rubrique, Intitulé) des sites
	 * 
	 * @return Hashtable<code rubrique, nom du site>
	 * @throws Exception
	 */
	public static Hashtable<String, String> getListeSiteParRubrique() throws Exception {
		final Hashtable<String, String> mapsListeSite = new Hashtable<String, String>();
		for (final InfosSite infoSite : Site.getListeInfosSites().values()) {
			mapsListeSite.put(infoSite.getCodeRubrique(), infoSite.getIntitule());
		}
		return mapsListeSite;
	}

	/**
	 * Methode renvoyant une Hashtable contenant les couples(Code rubrique, Intitulé) des sites en ligne
	 * 
	 * @return Hashtable<code rubrique, nom du site>
	 * @throws Exception
	 */
	public static Hashtable<String, String> getListeSiteEnLigneParRubrique() throws Exception {
		final Hashtable<String, String> mapsListeSiteEnligne = new Hashtable<String, String>();
		List<String> sitesNonVisibles = new ArrayList<String>();
		final String paramSitesNonVisibles = PropertyHelper.getCoreProperty("recherche.sites_non_visibles");
		if (paramSitesNonVisibles != null) {
			sitesNonVisibles = Arrays.asList(paramSitesNonVisibles.split(";"));
		}
		for (final InfosSite infoSite : Site.getListeInfosSites().values()) {
			if (!sitesNonVisibles.contains(infoSite.getAlias())) {
				mapsListeSiteEnligne.put(infoSite.getCodeRubrique(), infoSite.getIntitule());
			}
		}
		return mapsListeSiteEnligne;
	}
}