/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.extracteur;

/**
 * Permet de chercher dans une chaine de caractère si un tag est présent ou non. Utiliser pour chercher dans une chaine venant généralement de la toolbox si un tag est présent.
 * 
 * @author olivier.camon
 * 
 */
public interface ExtracteurTag {

	/**
	 * 
	 * @param texte
	 *            le texte pouvant contenir le tag
	 * @param baliseOuvrante
	 *            la balise de début de tag
	 * @param baliseFermante
	 *            la balise de fin du tag
	 * @return le contenu du tag ainsi que ses balises ouvrante / fermante si il est présent ou null si il n'est pas présent.
	 */
	public String getContenuTagPresentDansTexte(String texte, String baliseOuvrante, String baliseFermante);
}
