/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.extracteur.impl;

import org.apache.commons.lang3.StringUtils;

import com.kportal.tag.extracteur.ExtracteurTag;

public class ExtracteurHtmlEnDehorsDuTag implements ExtracteurTag {

	private String identifiantTag;

	public String getIdentifiantTag() {
		return identifiantTag;
	}

	public void setIdentifiantTag(String identifiantTag) {
		this.identifiantTag = identifiantTag;
	}

	@Override
	public String getContenuTagPresentDansTexte(String texte, String baliseOuvrante, String baliseFermante) {
		String contenuDuTag = StringUtils.EMPTY;
		int indexIdentifiant = StringUtils.indexOf(texte, identifiantTag);
		if (indexIdentifiant >= 0) {
			String texteAvantId = StringUtils.substring(texte, 0, indexIdentifiant);
			int indexBaliseOuvrante = StringUtils.lastIndexOf(texteAvantId, baliseOuvrante);
			int indexBaliseFermante = StringUtils.indexOf(texte, baliseFermante, indexBaliseOuvrante);
			if (indexBaliseOuvrante != -1 && indexBaliseFermante != -1 && indexBaliseOuvrante <= indexBaliseFermante) {
				contenuDuTag = StringUtils.substring(texte, indexBaliseOuvrante, indexBaliseFermante + baliseFermante.length());
			}
		}
		return contenuDuTag;
	}
}
