/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur;

import java.util.List;

/**
 * Permet à partir d'un texte à interpreter (généralement de la toolbox) d'interpreter un tag et de retourner le contenu HTML
 * 
 * @author olivier.camon
 * 
 */
public interface InterpreteurTag {

	/**
	 * Interprete le tag fourni en paramètre pour retourner généralement du code html à afficher en FO
	 * 
	 * @param texteAInterpreter
	 *            le contenu du tag à interpreter
	 * @param baliseOuvrante
	 *            la balise de début du tag
	 * @param baliseFermante
	 *            la balise de fin du tag
	 * @return le tag interpreté
	 * @throws Exception
	 *             hu...
	 */
	String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception;

	/**
	 * Permet pour certains tag (liens de fiches par exemple) de calculer si des pages sont référencés dans d'autre page
	 * 
	 * @param texteAInterpreter
	 *            le contenu du tag
	 * @param baliseOuvrante
	 *            la balise de début du tag
	 * @param baliseFermante
	 *            la balise de fin du tag
	 * @return la / les références du tags
	 */
	String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante);

	/**
	 * Permet de connaitre le contexte dans lequel le tag doit être utilisé.
	 * 
	 * @return la liste des cas dans lequel il doit être utilisé.
	 */
	List<String> getTypesInterpreteur();
}
