/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur.impl;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.kportal.tag.interpreteur.InterpreteurTag;

public abstract class AbstractInterpreteurTag implements InterpreteurTag {

	public List<String> typesInterpreteur;

	public void setTypesInterpreteur(List<String> typesInterpreteur) {
		this.typesInterpreteur = typesInterpreteur;
	}

	@Override
	public List<String> getTypesInterpreteur() {
		return typesInterpreteur;
	}

	protected String supprimerBalisesDuTexte(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
		return StringUtils.substring(texteAInterpreter, baliseOuvrante.length(), texteAInterpreter.length() - baliseFermante.length());
	}
}
