/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur.impl;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.module.plugin.toolbox.IPluginTag;
import com.kportal.frontoffice.util.JSPIncludeHelper;
import com.kportal.tag.interpreteur.InterpreteurTemplateTag;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

public class DefaultInterpreteurTemplateTag extends AbstractInterpreteurTag implements InterpreteurTemplateTag {

	public IPluginTag pluginTag;

	public String pathJsp;

	@Override
	public String getPathJsp() {
		return pathJsp;
	}

	@Override
	public void setPathJsp(String pathJsp) {
		this.pathJsp = pathJsp;
	}

	@Override
	public IPluginTag getPluginTag() {
		return pluginTag;
	}

	@Override
	public void setPluginTag(IPluginTag pluginTag) {
		this.pluginTag = pluginTag;
	}

	@Override
	public String getOutputJsp(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
		String path = ExtensionHelper.getTemplateExtension(pluginTag.getIdExtension(), pathJsp, Boolean.TRUE);
		return JSPIncludeHelper.getOutputJsp(out, context, request, response, path);
	}

	@Override
	public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
		String param = StringUtils.substringBetween(texteAInterpreter, baliseOuvrante, baliseFermante);
		param = StringEscapeUtils.unescapeHtml4(param);
		param = StringUtils.replace(param, "#", "&");
		ContexteUniv ctx = ContexteUtil.getContexteUniv();
		// test que le tag est genere pour une jsp en front
		if (ctx.getJspWriter() != null && pluginTag != null && StringUtils.isNotEmpty(pathJsp)) {
			ctx.getRequeteHTTP().setAttribute("PARAM", param);
			return getOutputJsp(ctx.getJspWriter(), ctx.getServletContext(), ctx.getRequeteHTTP(), ctx.getReponseHTTP());
		}
		return "";
	}

	@Override
	public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
		return "";
	}
}
