/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur.impl;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;

public class InterpreteurIdFichier extends AbstractInterpreteurTag {

    protected static String baliseInterneOuvrante = "[id-fichier]";

    protected static String baliseInterneFermante = "[/id-fichier]";

    @Override
    public String interpreterTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) throws Exception {
        // texteAInterpreter = <a href="[id-fichier]654646465654[/id-fichier]">bla bla bla</a>
        final StringBuilder newTexte = new StringBuilder();
        // <a href="
        newTexte.append(StringUtils.substringBefore(texteAInterpreter, baliseInterneOuvrante));
        String idFichier = StringUtils.substringBetween(texteAInterpreter, baliseInterneOuvrante, baliseInterneFermante);
        if (idFichier.startsWith(";")) {
            idFichier = idFichier.substring(1);
        }
        final Media media = Media.getMedia(new Long(idFichier));
        String url = media.getUrlAbsolue();
        if (ContexteUtil.getContexteUniv().getFicheCourante() != null) {
            url += (url.indexOf("?") != -1 ? "&" : "?") + "ID_FICHE=" + ContexteUtil.getContexteUniv().getFicheCourante().getIdFiche();
        }
        final String typeDisposition = StringUtils.defaultIfEmpty(PropertyHelper.getCoreProperty("telechargement.disposition"), "attachment");
        if (typeDisposition.equalsIgnoreCase("attachment")) {
            url += (url.indexOf("?") != -1 ? "&" : "?") + "INLINE=FALSE";
        }
        // <a href="http://www.site.com/media
        newTexte.append(URLResolver.getAbsoluteUrl(url, ContexteUtil.getContexteUniv()));
        // ajout de l'extension et du poids du fichier à la fin du libellé
        final String title = StringUtils.isBlank(media.getTitre()) ? media.getSource() : media.getTitre();
        String weight = "%d %s";
        if (media.getPoids() > 1000000) {
            weight = String.format(weight, media.getPoids() / 1000000, "Go");
        } else if (media.getPoids() > 1000) {
            weight = String.format(weight, media.getPoids() / 1000, "Mo");
        } else {
            weight = String.format(weight, media.getPoids(), "Ko");
        }
        // <a href="http://www.site.com/media" title="Télécharger 'title' [jpeg - 20ko]
        newTexte.append(String.format("\" title=\"Télécharger '%s' [%s - %s]", title, media.getExtension().toUpperCase(), weight));
        // <a href="http://www.site.com/media" title="Télécharger 'title' [jpeg - 20ko]">bla bla bla</a>
        newTexte.append(StringUtils.substringAfter(texteAInterpreter, baliseInterneFermante));
        /*
         * if (MarkerFactory.isMarkerActivated()){ String libelle =
		 * "Document_"+idFichier; Fichiergw fic = new Fichiergw();
		 * fic.setCtx(_ctx); fic.init(); if (fic.select("WHERE
		 * CODE='"+idFichier+"' LIMIT 0,1")>0){ fic.nextItem(); libelle =
		 * fic.getNomFichierJoint(); }
		 *
		 * String urlTracking = MarkerFactory.determinerUrlTracking(_ctx,
		 * URLResolver.getAbsoluteUrl(url, _ctx), libelle,
		 * MarkerFactory.TYPE_FILE); if (urlTracking.length()>0)
		 * newTexte.append("\" onclick=\""+urlTracking+";return true;"); }
		 */
        return newTexte.toString();
    }

    @Override
    public String getReferenceTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) {
        try {
            return interpreterTag(texteAInterpreter, baliseOuvrante, baliseFermante);
        } catch (final Exception e) {
            return StringUtils.EMPTY;
        }
    }
}
