/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur.impl;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;

public class InterpreteurInsertionFormulaire extends AbstractInterpreteurTag {

	@Override
	public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
		String urlDuLien = StringUtils.EMPTY;
		ContexteUniv ctx = ContexteUtil.getContexteUniv();
		texteAInterpreter = supprimerBalisesDuTexte(texteAInterpreter, baliseOuvrante, baliseFermante);
		urlDuLien = URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFormulaire(ctx, texteAInterpreter, ctx.getLangue(), Boolean.TRUE, ctx.getCodeRubriquePageCourante()), ctx);
		return urlDuLien;
	}

	@Override
	public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
		return StringUtils.EMPTY;
	}
}
