/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur.impl;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteUtil;

public class InterpreteurMailtoIndexation extends InterpreteurMailto {

	@Override
	public String interpreterTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) {
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		String contenuTagMailto = StringUtils.substringBetween(texteAInterpreter, baliseInterneOuvrante, baliseInterneFermante);
		contenuTagMailto = StringUtils.defaultString(contenuTagMailto);
		String texteInterprete = StringUtils.EMPTY;
		// nouveau tag de la forme [mailto]email=annuaire;549805613&subject=[...]&body=[...][/mailto]
		if (contenuTagMailto.startsWith("email=")) {
			final String mail = RequeteUtil.renvoyerParametre(contenuTagMailto, "email");
			if (mail.indexOf(";") != -1) {
				texteInterprete = getAdresseMailFromAnnuaire(ctx, mail);
			}
		} else {
			texteInterprete = getAdresseMailFromAnnuaire(ctx, contenuTagMailto);
		}
		if (StringUtils.isNotBlank(texteInterprete)) {
			texteInterprete = StringUtils.replace(texteAInterpreter, baliseInterneOuvrante + contenuTagMailto + baliseInterneFermante, texteInterprete);
		}
		return texteInterprete;
	}
}
