/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.tag.interpreteur.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.univ.objetspartages.om.Media;

public class VideoInterpreteurTemplateTag extends DefaultInterpreteurTemplateTag {

    private static Pattern IMAGEID_PATTERN = Pattern.compile("\\[id-image]([0-9]+)\\[/id-image]");

    @Override
    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        String decoratedText = texteAInterpreter;
        if(!decoratedText.contains("IMGURL")) {
            final Matcher idMatcher = IMAGEID_PATTERN.matcher(decoratedText);
            if(idMatcher.find()) {
                final String id = idMatcher.group(1);
                final Long mediaId = Long.parseLong(id);
                final Media media = Media.getMedia(mediaId);
                decoratedText = decoratedText.replace("URL", "IMGURL=" + media.getUrlVignette() + "#URL");
            }
        }
        return super.interpreterTag(decoratedText, baliseOuvrante, baliseFermante);
    }
}
