/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.util;

public class StatutsMessage {

	public final static String ERROR = "error";

	public final static String WARNING = "warning";

	public final static String SUCCESS = "success";

	public final static String NO_STATE = "nostate";

	private String type = NO_STATE;

	private String titre;

	private String message = "";

	private String etat;

	private String module = "";

	private String lien = "";

	private String texteLien = "Cliquez ici pour résoudre le problème";

	public String getType() {
		return type;
	}

	public StatutsMessage setType(String type) {
		this.type = type;
		return this;
	}

	public String getTitre() {
		return titre;
	}

	public StatutsMessage setTitre(String titre) {
		this.titre = titre;
		return this;
	}

	public String getMessage() {
		return message;
	}

	public StatutsMessage setMessage(String message) {
		this.message = message;
		return this;
	}

	public String getEtat() {
		return etat;
	}

	public StatutsMessage setEtat(String etat) {
		this.etat = etat;
		return this;
	}

	public String getModule() {
		return module;
	}

	public StatutsMessage setModule(String module) {
		this.module = module;
		return this;
	}

	public String getLien() {
		return lien;
	}

	public StatutsMessage setLien(String lien) {
		this.lien = lien;
		return this;
	}

	public String getTexteLien() {
		return texteLien;
	}

	public StatutsMessage setTexteLien(String texteLien) {
		this.texteLien = texteLien;
		return this;
	}
}
