/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 6 juil. 2006
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.ksup.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;

import javax.servlet.jsp.JspWriter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

public class UnivFmt {

	public static Logger LOG = LoggerFactory.getLogger(UnivFmt.class);

	/*
	 * FIXME : controle d'une faile Xss potentielle sur le select
	 */
	public static void insererComboStructuresEnseignement(final ContexteUniv ctx, final Writer out, final String nomDonnee, final String idCss) {
		try {
			out.write("<select id=\"" + idCss + "\" name=\"" + nomDonnee + "\" size=\"1\">");
			insererContenuComboStructuresEnseignement(ctx, out);
			out.write("</select>");
		} catch (final Exception e) {
			LOG.error("erreur lors de l'ecriture sur le writer", e);
		}
	}

	public static void insererContenuComboStructuresEnseignement(final ContexteUniv ctx, final Writer out) {
		try {
			final Collection<InfosStructure> listeStructures = com.univ.objetspartages.om.Structure.renvoyerItemStructure("00").getListeSousStructuresTousNiveaux();
			final TreeSet<String> tree = new TreeSet<String>();
			final Iterator<InfosStructure> it = listeStructures.iterator();
			com.univ.objetspartages.om.InfosStructure infosSt;
			while (it.hasNext()) {
				infosSt = it.next();
				if (infosSt.getAttributSpecifique1().equals("0")) {
					tree.add(infosSt.getLibelleLong() + "#" + infosSt.getCode());
				}
			}
			if (!(tree.isEmpty())) {
				final Iterator<String> itSt = tree.iterator();
				while (it.hasNext()) {
					final String[] chaine = itSt.next().split("#", -2);
					out.write("<option value=\"" + chaine[1] + "\">" + chaine[0] + "</option>");
				}
			}
		} catch (final Exception e) {
			LOG.error("erreur lors de l'insertion d'une combo structures", e);
		}
	}

	public void insererComboStructuresEnseignement(final com.jsbsoft.jtf.core.FormateurJSP fmt, final javax.servlet.jsp.JspWriter out,
		final com.jsbsoft.jtf.core.InfoBean infoBean, final String nomDonnee, final int optionModification, final String nomZone) throws Exception {
		// AM 200412 : zones invisibles pour fiches LMD
		if (optionModification == -1) {
			return;
		}
		insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
		insererContenuComboStructuresEnseignement(fmt, out, infoBean, nomDonnee, optionModification, nomZone);
		insererFinChamp(out);
	}

	public void insererContenuComboStructuresEnseignement(final com.jsbsoft.jtf.core.FormateurJSP fmt, final javax.servlet.jsp.JspWriter out,
		final com.jsbsoft.jtf.core.InfoBean infoBean, final String nomDonnee, final int optionModification, final String nomZone) {
		final Collection<InfosStructure> listeStructures = com.univ.objetspartages.om.Structure.renvoyerItemStructure(Structure.CODE_STRUCTURE_ROOT).getListeSousStructuresTousNiveaux();
		final Hashtable<String, String> listeUfr = new Hashtable<>();
		final Iterator<InfosStructure> it = listeStructures.iterator();
		com.univ.objetspartages.om.InfosStructure infosSt;
		String libelleFiche = "";
		final Locale localeContexte = ContexteUtil.getContexteUniv().getLocale();
		final String indiceLocale = String.valueOf(LangueUtil.getIndiceLocale(localeContexte));
		while (it.hasNext()) {
			infosSt = it.next();
			libelleFiche = infosSt.getLibelleLong();
			if (!indiceLocale.equals(infosSt.getLangue())) {
				libelleFiche = Structure.renvoyerItemStructure(infosSt.getCode(), indiceLocale).getLibelleLong();
			}
			if (infosSt.getAttributSpecifique1().equals("0")) {
				listeUfr.put(infosSt.getCode(), libelleFiche);
			}
		}
		infoBean.set(nomZone, listeUfr);
		fmt.insererComboHashtable(out, infoBean, nomDonnee, optionModification, nomZone);
	}

	/**
	 * Insère le code HTML de l'entete d'un champ
	 *
	 * @throws IOException
	 */
	private void insererEnteteChamp(final JspWriter out, final String nomDonnee, String nomZone, final int optionModification) throws IOException {
		if (optionModification == FormateurJSP.SAISIE_OBLIGATOIRE) {
			nomZone += " (*)";
		}
		out.println("<p>");
		if (nomZone.length() > 0) {
			out.println("<label for=\"" + nomDonnee + "\" class=\"colonne\"> " + nomZone + "</label>");
		}
	}

	/**
	 * Insère le code HTML de la fin d'un champ
	 */
	private void insererFinChamp(final JspWriter out) throws IOException {
		out.println("</p>");
	}
}
