/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.autocomplete.cache;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.kdecole.cache.aspect.TempCacheGet;
import com.univ.autocomplete.bean.AutoCompleteSuggestion;
import com.univ.autocomplete.processus.GestionAutoCompletion;

public class CacheAutoCompletionManager {

	public static final String ID_BEAN = "cacheAutoCompletionManager";

	@TempCacheGet(key = "CacheAutoCompletionManager.traiterRecherche", onlyUseFirstParameterForKeyGeneration = true, contextual = false)
	public List<AutoCompleteSuggestion> traiterRecherche(final String key, final GestionAutoCompletion autoCompletion, final HttpServletRequest req) {
		return autoCompletion.traiterRechercheDepuisRequete(req);
	}
}
