/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.autocomplete.processus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.jsbsoft.jtf.textsearch.util.RechercheUtilBO;
import com.univ.autocomplete.bean.AutoCompleteSuggestion;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;

public class MultiFicheAutoCompletion extends GestionAutoCompletion {

	private static final Logger LOG = LoggerFactory.getLogger(MultiFicheAutoCompletion.class);

	public static final String ID_BEAN = "multiFicheAutoComplete";

	@Override
	public List<AutoCompleteSuggestion> traiterRechercheDepuisRequete(final HttpServletRequest req) {
		List<AutoCompleteSuggestion> resultats = new ArrayList<AutoCompleteSuggestion>();
		final AutorisationBean autorisations = (AutorisationBean) SessionUtil.getInfosSession(req).get(SessionUtilisateur.AUTORISATIONS);
		if (autorisations == null) {
			return resultats;
		}
		try {
			resultats = getResults(autorisations, RechercheUtilBO.traiterRecherche(autorisations, ""));
		} catch (final Exception e) {
			LOG.error("Impossible d'executer la recherche", e);
			resultats = Collections.<AutoCompleteSuggestion> emptyList();
		}
		return resultats;
	}

	/**
	 * A partir de l'objet FicheUniv, on retrouve l'ensemble des fiches et on les map dans une liste de résultat exploitable
	 * 
	 * @param fiche
	 * @return
	 * @throws Exception
	 */
	private static List<AutoCompleteSuggestion> getResults(final AutorisationBean autorisations, final List<ResultatRecherche> liste) throws Exception {
		final List<AutoCompleteSuggestion> resultats = new ArrayList<AutoCompleteSuggestion>();
		for (final ResultatRecherche res : liste) {
			final AutoCompleteSuggestion auto = new AutoCompleteSuggestion();
			auto.setData(res);
			auto.setValue(res.getTitre());
			resultats.add(auto);
		}
		return resultats;
	}

	@Override
	public String getKeyForCache() {
		String code = "anonyme";
		if (ContexteUtil.getContexteUniv() != null) {
			if (StringUtils.isNotEmpty(ContexteUtil.getContexteUniv().getCode())) {
				code = ContexteUtil.getContexteUniv().getCode();
			}
		}
		return String.format("%s_%s", ID_BEAN, code);
	}
}
