/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.autocomplete.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.univ.autocomplete.bean.AutoCompleteSuggestion;
import com.univ.autocomplete.bean.AutoCompletionObject;
import com.univ.autocomplete.cache.CacheAutoCompletionManager;
import com.univ.autocomplete.processus.GestionAutoCompletion;
import com.univ.autocomplete.utils.AutoCompletionManager;
import com.univ.autocomplete.utils.AutoCompletionUtils;

public class AutoCompletionServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7982996758134619952L;

	private static final Logger LOG = LoggerFactory.getLogger(AutoCompletionServlet.class);

	@Override
	protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
		final ObjectMapper mapper = new ObjectMapper();
		mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
		try {
			final String query = StringUtils.defaultString(req.getParameter("query"));
			final String autoCompletionBeanName = req.getParameter(AutoCompletionUtils.PARAM_BEAN_AUTOCOMPLETION);
			final GestionAutoCompletion gestionAutoCompletion = AutoCompletionManager.getGestionAutoCompletion(autoCompletionBeanName);
			final CacheAutoCompletionManager cacheAutoCompletionManager = (CacheAutoCompletionManager) ApplicationContextManager.getCoreContextBean(CacheAutoCompletionManager.ID_BEAN);
			final List<AutoCompleteSuggestion> resultats = cacheAutoCompletionManager.traiterRecherche(query, gestionAutoCompletion, req);
			final AutoCompletionObject autoComplete = new AutoCompletionObject();
			autoComplete.setQuery(query);
			autoComplete.setSuggestions(AutoCompletionUtils.filtrerResultats(resultats, query));
			resp.setContentType("application/json");
			resp.setCharacterEncoding("UTF-8");
			resp.getWriter().write(mapper.writeValueAsString(autoComplete));
		} catch (final Exception e) {
			LOG.error("Une erreur est survenue lors de la construction de la liste de propositions : " + e.getMessage());
		}
	}
}
