/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.autocomplete.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.univ.autocomplete.bean.AutoCompleteSuggestion;

public class AutoCompletionUtils {

	private static int MAX_AUTOCOMPLETION_RESULTS = 20;

	public static final String PARAM_BEAN_AUTOCOMPLETION = "BEAN_AUTO_COMPLETION";

	public static int getNbMaxResults() {
		return MAX_AUTOCOMPLETION_RESULTS;
	}

	public static List<AutoCompleteSuggestion> filtrerResultats(List<AutoCompleteSuggestion> list, String query) {
		List<AutoCompleteSuggestion> resultats = new ArrayList<>();
		Iterator<AutoCompleteSuggestion> it = list.iterator();
		while (it.hasNext() && resultats.size() <= MAX_AUTOCOMPLETION_RESULTS) {
			AutoCompleteSuggestion currentSuggestion = it.next();

			if (StringUtils.containsIgnoreCase(currentSuggestion.getValue(), query)) {
				resultats.add(currentSuggestion);
			}
		}
		return resultats;
	}
}
