/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.batch;

import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import ch.qos.logback.classic.Level;


public abstract class LogReportThread implements Runnable, LogReporter {

	public Logger logger;

	@Override
	public void run() {

		// creation de l'objet logReport
		LogReport logReport = new LogReport(getLogFileName(), getLogLevel(), isReportByMail(), getReportSubject());
		logger = logReport.getLogger();
		// indication automatique du début du batch
		Long start = System.currentTimeMillis();
		logger.info("DEBUT " + this.getClass().getSimpleName());
		// exécution du batch
		perform();
		// indication automatique de la fin du batch et durée
		Long duree = System.currentTimeMillis() - start;
		logger.info("FIN " + this.getClass().getSimpleName() + ", durée : " + String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(duree),
				TimeUnit.MILLISECONDS.toMinutes(duree) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duree)),
				TimeUnit.MILLISECONDS.toSeconds(duree) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duree))));
		// finalisation du report
		logReport.close();

	}

	public abstract void perform();

	/**
	 * Par défaut on revoit le nom de la classe en minuscule
	 */
	@Override
	public String getLogFileName() {
		return this.getClass().getSimpleName().toLowerCase();
	}

	/**
	 * Par défaut on revoit vide
	 */
	@Override
	public String getReportSubject() {
		return StringUtils.EMPTY;
	}

	/**
	 * Par défaut on revoit le niveau INFO
	 */
	@Override
	public Level getLogLevel() {
		return Level.INFO;
	}

	/**
	 * Par défaut on revoit vide
	 */
	@Override
	public String getLogDescription(){
		return StringUtils.EMPTY;
	}

	/**
	 * Par défaut l'envoi de mail est désactivé
	 */
	@Override
	public boolean isReportByMail() {
		return false;
	}

}
