/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.batch.imports;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;

/**
 * @author pierre.cosson
 * 
 */
public class ExtentionsFilter implements FilenameFilter {

	/**
	 * Liste des extentions de fichiers supportées par le filtre
	 */
	private List<String> extentions;

	/**
	 * Constructeur
	 * 
	 * @param extentions
	 *            Liste des extentions de fichiers supportées par le filtre
	 */
	public ExtentionsFilter(List<String> extentions) {
		this.extentions = extentions;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	@Override
	public boolean accept(File dir, String name) {
		int lastPointIndex = name.lastIndexOf(".");
		if (lastPointIndex > 0 && lastPointIndex < name.length()) {
			// le point ne doit pas être le premier caractére ni le dernier.
			String extention = name.substring(lastPointIndex + 1);
			return this.extentions.contains(extention);
		}
		return false;
	}
}
