/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.batch.imports;

import java.io.File;
import java.io.FilenameFilter;

// TODO: Auto-generated Javadoc
/**
 * Filtre n'acceptant que les fichiers xml.
 */
public class XMLFilter implements FilenameFilter {

	/**
	 * Renvoie true si le fichier est un fichier xml.
	 * 
	 * @param dir
	 *            the dir
	 * @param name
	 *            the name
	 * 
	 * @return true, if accept
	 */
	@Override
	public boolean accept(File dir, String name) {
		return name.toLowerCase().endsWith(".xml");
	}
}
