/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.collaboratif.bean;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import com.univ.objetspartages.bean.AbstractPersistenceBean;

/**
 * Created on 27/04/15.
 */
public class UserRolesCollaboratifBean extends AbstractPersistenceBean {

    private String codeUser;

    private String codeRole;

    private Long idCollaboratif;

    public String getCodeUser() {
        return codeUser;
    }

    public void setCodeUser(String codeUser) {
        this.codeUser = codeUser;
    }

    public String getCodeRole() {
        return codeRole;
    }

    public void setCodeRole(String codeRole) {
        this.codeRole = codeRole;
    }

    public Long getIdCollaboratif() {
        return idCollaboratif;
    }

    public void setIdCollaboratif(Long idCollaboratif) {
        this.idCollaboratif = idCollaboratif;
    }

    @Override
    public int hashCode(){
        return new HashCodeBuilder()
            .append(codeUser)
            .append(codeRole)
            .append(idCollaboratif)
            .toHashCode();
    }

    @Override
    public boolean equals(final Object obj){
        if(obj instanceof UserRolesCollaboratifBean){
            final UserRolesCollaboratifBean other = (UserRolesCollaboratifBean) obj;
            return new EqualsBuilder()
                .append(codeUser, other.codeUser)
                .append(codeRole, other.codeRole)
                .append(idCollaboratif, other.idCollaboratif)
                .isEquals();
        } else{
            return false;
        }
    }
}
