/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.collaboratif.om;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.datasource.manager.impl.BasicDataSourceDAOManager;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.univ.collaboratif.bean.UserRolesCollaboratifBean;
import com.univ.collaboratif.dao.impl.UserRolesCollaboratifDao;
import com.univ.collaboratif.service.CacheEspaceManager;
import com.univ.collaboratif.sgbd.EspacecollaboratifDB;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.EscapeString;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

/**
 * The Class Espacecollaboratif.
 */
public class Espacecollaboratif extends EspacecollaboratifDB implements Cloneable {

    public static final String ID_EXTENSION = "collaboratif";

    public static final PermissionBean PERMISSION_GESTIONNAIRE = new PermissionBean("TECH", "ges", "");

    /** The Constant ERREUR_ESPACE_INEXISTANT. */
    public static final String ERREUR_ESPACE_INEXISTANT = "ST_COLLABORATIF_ERREUR_ESPACE_INEXISTANT";

    /** The Constant ERREUR_AJOUT_MEMBRE. */
    public static final String ERREUR_AJOUT_MEMBRE = "ST_COLLABORATIF_ERREUR_AJOUT_MEMBRE";

    /** The Constant ERREUR_AJOUT_RESPONSABLE. */
    public static final String ERREUR_AJOUT_RESPONSABLE = "ST_COLLABORATIF_ERREUR_AJOUT_RESPONSABLE";

    /** The Constant ERREUR_AUCUN_ROLE_RESPONSABLE. */
    public static final String ERREUR_AUCUN_ROLE_RESPONSABLE = "ST_COLLABORATIF_ERREUR_AUCUN_ROLE_RESPONSABLE";

    /** The Constant ERREUR_SUPPRESSION_RESPONSABLE. */
    public static final String ERREUR_SUPPRESSION_RESPONSABLE = "ST_COLLABORATIF_ERREUR_SUPPRESSION_RESPONSABLE";

    /** The Constant ERREUR_SUPPRESSION_MEMBRE_NON_INSCRIT. */
    public static final String ERREUR_SUPPRESSION_MEMBRE_NON_INSCRIT = "ST_COLLABORATIF_ERREUR_SUPPRESSION_MEMBRE_NON_INSCRIT";

    /** The Constant ERREUR_INSCRIPTION_EN_COURS. */
    public static final String ERREUR_INSCRIPTION_EN_COURS = "ST_COLLABORATIF_ERREUR_INSCRIPTION_EN_COURS";

    /** The Constant ERREUR_INSCRIPTION_DEJA_INSCRIT. */
    public static final String ERREUR_INSCRIPTION_DEJA_INSCRIT = "ST_COLLABORATIF_ERREUR_INSCRIPTION_DEJA_INSCRIT";

    /** The Constant ERREUR_MAIL_SELECTION_UTILISATEUR. */
    public static final String ERREUR_MAIL_SELECTION_UTILISATEUR = "ST_COLLABORATIF_ERREUR_MAIL_SELECTION_UTILISATEUR";

    /** The Constant CONFIRMATION_MAIL_ENVOI. */
    public static final String CONFIRMATION_MAIL_ENVOI = "ST_COLLABORATIF_CONFIRMATION_MAIL_ENVOI";

    /** The Constant ERREUR_MAIL_FICHIER. */
    public static final String ERREUR_MAIL_FICHIER = "ST_COLLABORATIF_ERREUR_MAIL_FICHIER";

    /** The Constant CONFIRMATION_DOCUMENTGW_VERROU_ON. */
    public static final String CONFIRMATION_DOCUMENTGW_VERROU_ON = "ST_COLLABORATIF_CONFIRMATION_DOCUMENTGW_VERROU_ON";

    /** The Constant CONFIRMATION_DOCUMENTGW_VERROU_OFF. */
    public static final String CONFIRMATION_DOCUMENTGW_VERROU_OFF = "ST_COLLABORATIF_CONFIRMATION_DOCUMENTGW_VERROU_OFF";

    /** The Constant ERREUR_MEMBRE_CRITERE. */
    public static final String ERREUR_MEMBRE_CRITERE = "ST_COLLABORATIF_ERREUR_MEMBRE_CRITERE";

    /** The Constant ERREUR_MEMBRE_AFFINER_CRITERE. */
    public static final String ERREUR_MEMBRE_AFFINER_CRITERE = "ST_COLLABORATIF_ERREUR_MEMBRE_AFFINER_CRITERE";

    /** The Constant CONFIRMATION_MEMBRE_AJOUT. */
    public static final String CONFIRMATION_MEMBRE_AJOUT = "ST_COLLABORATIF_CONFIRMATION_MEMBRE_AJOUT";

    /** The Constant CONFIRMATION_MEMBRE_SUPPRESSION. */
    public static final String CONFIRMATION_MEMBRE_SUPPRESSION = "ST_COLLABORATIF_CONFIRMATION_MEMBRE_SUPPRESSION";

    /** The Constant CONFIRMATION_DEMANDE_MEMBRE_SUPPRESSION. */
    public static final String CONFIRMATION_DEMANDE_MEMBRE_SUPPRESSION = "ST_COLLABORATIF_CONFIRMATION_DEMANDE_MEMBRE_SUPPRESSION";

    /** The Constant CONFIRMATION_MEMBRE_MODIFICATION. */
    public static final String CONFIRMATION_MEMBRE_MODIFICATION = "ST_COLLABORATIF_CONFIRMATION_MEMBRE_MODIFICATION";

    /** The Constant ERREUR_MEMBRE_DROITS. */
    public static final String ERREUR_MEMBRE_DROITS = "ST_COLLABORATIF_ERREUR_MEMBRE_DROITS";

    /** The Constant CONFIRMATION_NEWSLETTER_MODIFICATION. */
    public static final String CONFIRMATION_NEWSLETTER_MODIFICATION = "ST_COLLABORATIF_CONFIRMATION_NEWSLETTER_MODIFICATION";

    /** The Constant CONFIRMATION_NEWSLETTER_DESACTIVEE. */
    public static final String CONFIRMATION_NEWSLETTER_DESACTIVEE = "ST_COLLABORATIF_CONFIRMATION_NEWSLETTER_DESACTIVEE";

    /** The Constant CONFIRMATION_NEWSLETTER_ENVOI. */
    public static final String CONFIRMATION_NEWSLETTER_ENVOI = "ST_COLLABORATIF_CONFIRMATION_NEWSLETTER_ENVOI";

    /** The Constant ALERTE_DESINSCRIPTION. */
    public static final String ALERTE_DESINSCRIPTION = "ST_COLLABORATIF_ALERTE_DESINSCRIPTION";

    /** The Constant RETOUR_INSCRIPTION. */
    public static final String RETOUR_INSCRIPTION = "ST_COLLABORATIF_RETOUR_INSCRIPTION";

    /** The Constant CONFIRMATION_DEMANDE_INSCRIPTION. */
    public static final String CONFIRMATION_DEMANDE_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_DEMANDE_INSCRIPTION";

    /** The Constant CONFIRMATION_INSCRIPTION. */
    public static final String CONFIRMATION_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_INSCRIPTION";

    /** The Constant ERREUR_INSCRIPTION_DROITS. */
    public static final String ERREUR_INSCRIPTION_DROITS = "ST_COLLABORATIF_ERREUR_INSCRIPTION_DROITS";

    /** The Constant CONFIRMATION_VALIDATION_INSCRIPTION. */
    public static final String CONFIRMATION_VALIDATION_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_VALIDATION_INSCRIPTION";

    /** The Constant CONFIRMATION_REFUS_INSCRIPTION. */
    public static final String CONFIRMATION_REFUS_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_REFUS_INSCRIPTION";

    /** The Constant CONFIRMATION_DESINSCRIPTION. */
    public static final String CONFIRMATION_DESINSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_DESINSCRIPTION";

    /** The Constant ERREUR_INSCRIPTION_TRAITEE. */
    public static final String ERREUR_INSCRIPTION_TRAITEE = "ST_COLLABORATIF_ERREUR_INSCRIPTION_TRAITEE";

    /** The Constant MAIL_OBJET_DEMANDE_INSCRIPTION. */
    public static final String MAIL_OBJET_DEMANDE_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_DEMANDE_INSCRIPTION";

    /** The Constant MAIL_MESSAGE_DEMANDE_INSCRIPTION. */
    public static final String MAIL_MESSAGE_DEMANDE_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_DEMANDE_INSCRIPTION";

    /** The Constant MAIL_OBJET_INSCRIPTION. */
    public static final String MAIL_OBJET_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_INSCRIPTION";

    /** The Constant MAIL_MESSAGE_INSCRIPTION. */
    public static final String MAIL_MESSAGE_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_INSCRIPTION";

    /** The Constant MAIL_OBJET_DESINSCRIPTION. */
    public static final String MAIL_OBJET_DESINSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_DESINSCRIPTION";

    /** The Constant MAIL_MESSAGE_DESINSCRIPTION. */
    public static final String MAIL_MESSAGE_DESINSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_DESINSCRIPTION";

    /** The Constant MAIL_OBJET_VALIDATION_INSCRIPTION. */
    public static final String MAIL_OBJET_VALIDATION_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_VALIDATION_INSCRIPTION";

    /** The Constant MAIL_MESSAGE_VALIDATION_INSCRIPTION. */
    public static final String MAIL_MESSAGE_VALIDATION_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_VALIDATION_INSCRIPTION";

    /** The Constant MAIL_OBJET_REFUS_INSCRIPTION. */
    public static final String MAIL_OBJET_REFUS_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_REFUS_INSCRIPTION";

    /** The Constant MAIL_MESSAGE_REFUS_INSCRIPTION. */
    public static final String MAIL_MESSAGE_REFUS_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_REFUS_INSCRIPTION";

    /** The Constant MAIL_OBJET_NOTIFICATION. */
    public static final String MAIL_OBJET_NOTIFICATION = "ST_COLLABORATIF_MAIL_OBJET_NOTIFICATION";

    /** The Constant MAIL_MESSAGE_NOTIFICATION. */
    public static final String MAIL_MESSAGE_NOTIFICATION = "ST_COLLABORATIF_MAIL_MESSAGE_NOTIFICATION";

    /** The Constant ERREUR_ACCES_MESSAGE. */
    public static final String ERREUR_ACCES_MESSAGE = "ST_COLLABORATIF_ERREUR_ACCES_MESSAGE";

    /** The Constant ERREUR_ACCES_INSCRIPTION. */
    public static final String ERREUR_ACCES_INSCRIPTION = "ST_COLLABORATIF_ACCES_INSCRIPTION";

    private static final Logger LOG = LoggerFactory.getLogger(Espacecollaboratif.class);

    private final UserRolesCollaboratifDao userRolesCollaboratifDao;

    /**
     * Instantiates a new espacecollaboratif.
     */
    public Espacecollaboratif() {
        super();
        userRolesCollaboratifDao = (UserRolesCollaboratifDao) ApplicationContextManager.getCoreContextBean(BasicDataSourceDAOManager.ID_BEAN,
            BasicDataSourceDAOManager.class).getDao(
            UserRolesCollaboratifBean.class);
    }

    /**
     * Vérifie si l'extension collaboratif est activée
     * @return True si l'extension est activée
     */
    public static boolean isExtensionActivated() {
        final IExtension extension = ExtensionHelper.getExtension(ID_EXTENSION);
        if (extension != null) {
            return extension.getEtat() == IExtension.ETAT_ACTIF;
        }
        return false;
    }

    /**
     * Renvoie les roles de type responsable affecté aux membres.
     *
     * @param codeEspace the code espace
     * @return the vector
     */
    public static Vector<String> renvoyerRolesTousLesMembres(final String codeEspace) {
        final Vector<String> res = new Vector<>();
        final InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(codeEspace);
        final Vector<String> listeRolesMembres = Chaine.getVecteurAccolades(infosEspace.getRolesMembre());
        for (final String codeRole : listeRolesMembres) {
            res.add(codeRole);
        }
        return res;
    }

    /**
     * Récupération de l'objet espace par son code.
     * @param ctx plus utiliser
     * @param code le code de l'espace à récupérer
     * @return l'espace ayant pour code celui fourni en paramètre ou null si non trouvé
     * @throws Exception lors de l'appel à la bdd
     * @deprecated le contexte ne sert plus, utiliser {@link Espacecollaboratif#getEspace(String)}
     */
    @Deprecated
    public static Espacecollaboratif getEspace(final OMContext ctx, final String code) throws Exception {
        return getEspace(code);
    }

    /**
     * Récupération de l'objet espace par son code.
     *
     * @param code le code de l'espace à récupérer
     * @return l'espace ayant pour code celui fourni en paramètre ou null si non trouvé
     * @throws Exception lors de l'appel à la bdd
     */
    public static Espacecollaboratif getEspace(final String code) throws Exception {
        Espacecollaboratif res = null;
        if (StringUtils.isNotEmpty(code)) {
            Espacecollaboratif espace = new Espacecollaboratif();
            try (ContexteDao ctx = new ContexteDao()) {
                espace.setCtx(ctx);
                espace.init();
                final ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("CODE", code));
                final int count = espace.select(whereCode.formaterSQL());
                if (count == 1 && espace.nextItem()) {
                    res = espace;
                }
            }
        }
        return res;
    }

    /**
     * Renvoie la liste de tous les espaces Peut être affiché directement dans une Combo
     *
     * @param ctx the ctx
     *
     * @return the liste espaces collaboratifs
     *
     * @throws Exception
     *             the exception
     * @deprecated
     */
    @Deprecated
    public static Hashtable<String, String> getListeEspacesCollaboratifs(final OMContext ctx) throws Exception {
        return getListeEspacesCollaboratifs(ctx, false);
    }

    /**
     * Renvoie la liste de tous les espaces Peut être affiché directement dans une Combo
     *
     * @param ctx the ctx
     * @param avecTheme the avec theme
     * @return the liste espaces collaboratifs
     * @throws Exception the exception
     * @deprecated Méthode plus utilisée
     */
    @Deprecated
    public static Hashtable<String, String> getListeEspacesCollaboratifs(final OMContext ctx, final boolean avecTheme) throws Exception {
        final Hashtable<String, String> res = new Hashtable<>();
        for (final InfosEspaceCollaboratif espace : getListeEspaces()) {
            if (avecTheme) {
                String libelleTheme = Espacecollaboratif.getTheme(ctx, espace.getCodeTheme());
                res.put(espace.getCode(), libelleTheme + " - " + espace.getIntitule());
                if (!res.containsValue("T#" + espace.getCodeTheme())) {
                    res.put("T#" + espace.getCodeTheme(), libelleTheme + " - *");
                }
            } else {
                res.put(espace.getCode(), espace.getIntitule());
            }
        }
        return res;
    }

    /**
     * Récupération d'un espace stocké en mémoire.
     *
     * @param code the code
     * @return the infos espace collaboratif
     */
    public static InfosEspaceCollaboratif renvoyerItemEspace(final String code) {
        InfosEspaceCollaboratif res = CacheEspaceManager.getInstance().getItem(code);
        if (res == null) {
            res = new InfosEspaceCollaboratif();
        }
        return res;
    }

    /**
     *
     * @param ctx le contexte ne sert plus
     * @param code le code de l'espace dont on souhaite récupérer le titre
     * @return l'intitulé de l'espace ou le message BO_ESPACE_COLLAB_INEXISTANT
     * @throws Exception lors de la requête en bdd...
     * @deprecated utiliser {@link Espacecollaboratif#getIntitule(String)}
     */
    @Deprecated
    public static String getIntitule(final OMContext ctx, final String code) throws Exception {
        return getIntitule(code);
    }

    /**
     * Récupération de l'intitulé.
     *
     * @param code le code de l'espace dont on souhaite récupérer le titre
     * @return l'intitulé de l'espace ou le message BO_ESPACE_COLLAB_INEXISTANT
     * @throws Exception lors de la requête en bdd...
     */
    public static String getIntitule(final String code) throws Exception {
        String res = MessageHelper.getCoreMessage("BO_ESPACE_COLLAB_INEXISTANT");
        if (StringUtils.isEmpty(code)) {
            return res;
        }
        return StringUtils.defaultIfBlank(renvoyerItemEspace(code).getIntitule(), MessageHelper.getCoreMessage("BO_ESPACE_COLLAB_INEXISTANT"));
    }

    /**
     * Récupération de la chaine des responsables.
     *
     * @param ctx le contexte ne sert plus
     * @param code le code de l'espace dont on souhaite avoir les libelles des responsables
     * @return une chaine de caractères contenant le libellé des responsables séparé par des " / "
     * @throws Exception lors de la requête en bdd
     * @deprecated utiliser {@link Espacecollaboratif#getChaineResponsable(String)}
     */
    @Deprecated
    public static String getChaineResponsable(final OMContext ctx, final String code) throws Exception {
        return getChaineResponsable(code);
    }

    /**
     * Récupération de la chaine des responsables.
     *
     * @param code le code de l'espace dont on souhaite avoir les libelles des responsables
     * @return une chaine de caractères contenant le libellé des responsables séparé par des " / "
     * @throws Exception lors de la requête en bdd
     */
    public static String getChaineResponsable(final String code) throws Exception {
        String res = "";
        final Collection<String> gestionnaires = renvoyerUtilisateursGestionnaire(code);
        for (String codeGestionnaire : gestionnaires) {
            final Utilisateur user = Utilisateur.getUtilisateur(codeGestionnaire);
            if (user != null) {
                if (res.length() > 0) {
                    res += " / ";
                }
                res += user.getLibelle();
            }
        }
        return res;
    }

    /**
     * Gets the theme.
     *
     * @param ctx the ctx
     * @param codeTheme the code theme
     * @return Returns the theme.
     * @throws Exception the exception
     */
    public static String getTheme(final OMContext ctx, final String codeTheme) throws Exception {
        return Libelle.getLibelle("0110", codeTheme, ctx.getLocale());
    }

    /**
     * Renvoie la liste des espaces collaboratifs actifs.
     *
     * @return the liste espaces collaboratifs
     */
    public static Collection<InfosEspaceCollaboratif> getListeEspaces() {
        final Collection<InfosEspaceCollaboratif> listeEspaces = new ArrayList<>();
        final Espacecollaboratif espace = new Espacecollaboratif();
        try (ContexteDao ctx = new ContexteDao()) {
            espace.setCtx(ctx);
            espace.init();
            espace.select("");
            while (espace.nextItem()) {
                if (espace.getActif().equals("1")) {
                    InfosEspaceCollaboratif infosEspace = new InfosEspaceCollaboratif(espace.getIdEspacecollaboratif(), espace.getCode(), espace.getIntitule(), espace.getGroupesMembres(), espace.getGroupesConsultation(), espace.getGroupesInscription(), espace.getInscriptionFront(), espace.getRolesMembre(), espace.getTheme(), espace.getDescription(), espace.getCodeRubrique(), espace.getLangue(), "1".equals(espace.getActif()), new ArrayList<>(Chaine.getVecteurPointsVirgules(espace.getServices())));
                    listeEspaces.add(infosEspace);
                }
            }
        } catch (final Exception e) {
            LOG.error("Problème d'initialisation du cache des espaces", e);
        }
        return listeEspaces;
    }

    @Deprecated
    public static Hashtable<String, InfosEspaceCollaboratif> getListeEspacesCollaboratifs() {
        Hashtable<String, InfosEspaceCollaboratif> hListe = new Hashtable<>();
        for (InfosEspaceCollaboratif infosEspace : getListeEspaces()) {
            hListe.put(infosEspace.getCode(), infosEspace);
        }
        return hListe;
    }

    /**
     * Controler restriction.
     *
     * @param ctx the ctx
     * @param response the response
     * @throws Exception the exception
     * @deprecated Plus utilisé, remplacé par CollaboratifUtil.controlerAccesEspace
     */
    @Deprecated
    public static void controlerRestriction(final ContexteUniv ctx, final HttpServletResponse response) throws Exception {
        if (ctx.getAutorisation() == null) {
            UnivWebFmt.redirigerVersLogin(ctx, response, "");
        } else {
            InfosEspaceCollaboratif espaceCourant = ctx.getInfosEspace();
            if (!Espacecollaboratif.estMembreEspace(ctx, espaceCourant) && !Espacecollaboratif.estVisiteurEspace(ctx, espaceCourant)) {
                ctx.getRequeteHTTP().setAttribute("EXCLUSION_ESPACE", "true");
                String message = MessageHelper.getCoreMessage("ST_PAS_DROITS_ACCES");
                final Espacecollaboratif espace = Espacecollaboratif.getEspace(espaceCourant.getCode());
                if (espace != null) {
                    message = MessageHelper.getCoreMessage(Espacecollaboratif.ERREUR_ACCES_MESSAGE);
                    message = StringUtils.replace(message, "[espace]", espaceCourant.getIntitule());
                    if (message.length() == 0) {
                        message = "Vous ne disposez pas des droits d'accès à l'espace collaboratif : " + espaceCourant.getIntitule();
                    }
                    final Vector<String> vGroupesInscription = Chaine.getVecteurPointsVirgules(espace.getGroupesInscription());
                    boolean inscription = false;
                    if (vGroupesInscription.size() > 0) {
                        for (String groupeDsi : ctx.getGroupesDsi()) {
                            if (vGroupesInscription.contains(groupeDsi)) {
                                inscription = true;
                                break;
                            }
                        }
                    } else {
                        inscription = true;
                    }
                    if (inscription && espace.getActif().equals("1") && (espace.getInscriptionFront().equals("1") || espace.getInscriptionFront().equals("2"))) {
                        String lien = MessageHelper.getCoreMessage(Espacecollaboratif.ERREUR_ACCES_INSCRIPTION);
                        if (lien.length() == 0) {
                            lien = "Cliquez ici pour vous inscrire";
                        }
                        message += "<br />";
                        message += "<a href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlRelative(ctx, WebAppUtil.SG_PATH + "?ACTION=INSCRIPTION&amp;PROC=INSCRIPTION_ESPACE&amp;CODE_ESPACE=" + espace.getCode() + "&amp;INSCRIPTION_DIRECT=true"), ctx) + "&amp;RH=" + EscapeString.escapeURL(ctx.getCodeRubriquePageCourante()) + "\">" + lien + "</a>";
                    }
                }
                throw new ErreurApplicative(message);
            }
        }
    }

    /**
     * Sélection des utilisateurs d'un espace rattachés par leur groupe (ne renvoie pas les membres affectés directement).
     *
     * @param codeEspace the code espace
     * @return the vector
     * @throws Exception the exception
     * @deprecated Méthode plus utilisée
     */
    @Deprecated
    public static Collection<String> renvoyerCodesUtilisateursParEspaceParGroupe(final String codeEspace) throws Exception {
        final TreeSet<String> membres = new TreeSet<>();
        InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(codeEspace);
        // Recherche parmi les groupes membres
        Vector<String> membresGroupes = Chaine.getVecteurAccolades(infosEspace.getGroupesMembres());
        for (final String codeGroupe : membresGroupes) {
            membres.addAll(Groupeutilisateur.getVecteurUtilisateurs(codeGroupe));
        }
        return membres;
    }

    /**
     * Sélection des utilisateurs d'un espace. Cette recherche va également renvoyer les résultats des sous-groupes.
     *
     * @param codeEspace the code espace
     * @return the vector
     * @throws Exception the exception
     */
    public static Collection<String> renvoyerUtilisateursGestionnaire(final String codeEspace) throws Exception {
        return getListeUtilisateursPossedantPermissionPourUnEspace(PERMISSION_GESTIONNAIRE, codeEspace, false);
    }

    /**
     * Détermine la liste des utilisateurs ayant une permission donnée sur un espace
     * (utilisé dans 2 cas : droit de contribution / droit de validation sur un espace)
     *
     * Si renvoyerMails vaut true, ce ne sont pas les codes mais les mails qui sont renvoyés.
     *
     * @param permission
     *            the _permission
     * @param codeEspaceCollaboratif
     *            the _code espace collaboratif
     * @param renvoyerMails
     *            the renvoyer mails
     *
     * @return the liste utilisateurs possedant permission pour un espace
     *
     * @throws Exception
     *             the exception
     */
    public static TreeSet<String> getListeUtilisateursPossedantPermissionPourUnEspace(final PermissionBean permission, final String codeEspaceCollaboratif, final boolean renvoyerMails) throws Exception {
        final TreeSet<String> listeUtilisateurs = new TreeSet<>();
        final InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(codeEspaceCollaboratif);
        final String roleEspaceParDefaut = infosEspace.getRolesMembre();
        final Hashtable<String, String> rolesCollab = Role.getListeRolesEspaceCollaboratif();
        for (final String codeRole : rolesCollab.keySet()) {
            // On controle si le role contient la permission
            boolean roleOk = false;
            final InfosRole infosRole = Role.renvoyerItemRole(codeRole);
            final Vector<PermissionBean> permissions = infosRole.getVecteurPermissions();
            for (final PermissionBean permissionRole : permissions) {
                if (permissionRole.getChaineSerialisee().equals(permission.getChaineSerialisee())) {
                    roleOk = true;
                    break;
                }
            }
            if (roleOk) {
                final UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao) ApplicationContextManager.getCoreContextBean(BasicDataSourceDAOManager.ID_BEAN,
                    BasicDataSourceDAOManager.class).getDao(
                    UserRolesCollaboratifBean.class);
                final List<UserRolesCollaboratifBean> userRoles = userRolesCollaboratifDao.getByCodeRoleAndIdCollab(codeRole, infosEspace.getId());
                for (UserRolesCollaboratifBean currentUserRoles : userRoles) {
                    listeUtilisateurs.add(currentUserRoles.getCodeUser());
                }
                if (codeRole.equals(roleEspaceParDefaut)) {
                    // on ajoute aussi les utilisateurs des groupes membres
                    final Collection<String> groupesMembres = Chaine.getVecteurAccolades(infosEspace.getGroupesMembres());
                    for (final String codeGroupe : groupesMembres) {
                        listeUtilisateurs.addAll(Groupeutilisateur.getVecteurUtilisateurs(codeGroupe));
                    }
                }
            }
        }
        final TreeSet<String> res = new TreeSet<>();
        if (renvoyerMails) {
            for (final String codeUtilisateur : listeUtilisateurs) {
                final Utilisateur utilisateur = Utilisateur.getUtilisateur(codeUtilisateur);
                res.add(utilisateur.getAdresseMail() + ";" + utilisateur.getLibelle() + ";" + codeUtilisateur);
            }
        }
        return renvoyerMails ? res : listeUtilisateurs;
    }

    /**
     * Renvoie la liste des gestionnaires d'un espace
     *
     * @param codeEspace the code espace
     * @return the vector
     * @throws Exception the exception
     */
    public static Collection<String> renvoyerCodesUtilisateursParEspace(final String codeEspace) throws Exception {
        final TreeSet<String> listeMembres = new TreeSet<>();
        final UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao) ApplicationContextManager.getCoreContextBean(BasicDataSourceDAOManager.ID_BEAN,
            BasicDataSourceDAOManager.class).getDao(
            UserRolesCollaboratifBean.class);
        Espacecollaboratif espace = getEspace(codeEspace);
        for(UserRolesCollaboratifBean currentUser : userRolesCollaboratifDao.getByIdCollaboratif(espace.getIdEspacecollaboratif())) {
            listeMembres.add(currentUser.getCodeUser());
        }
        // Ajout des membres des groupes
        Collection<String> groupesMembres = Chaine.getVecteurAccolades(espace.getGroupesMembres());
        for (final String codeGroupe : groupesMembres) {
            listeMembres.addAll(Groupeutilisateur.getVecteurUtilisateurs(codeGroupe));
            //TODO FBI : gérer les sous-groupes
        }
        return listeMembres;
    }

    @Deprecated
    public static void supprimerUtilisateur(final OMContext _ctx, final String _codeMembre) throws Exception {
        supprimerUtilisateur(_codeMembre);
    }

    /**
     * Supprimer l'utilisateur de ses espaces co.
     *
     * @param codeMembre the code membre
     * @throws Exception the exception
     */
    public static void supprimerUtilisateur(final String codeMembre) throws Exception {
        final UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao) ApplicationContextManager.getCoreContextBean(BasicDataSourceDAOManager.ID_BEAN,
            BasicDataSourceDAOManager.class).getDao(
            UserRolesCollaboratifBean.class);
        userRolesCollaboratifDao.deleteByCodeUser(codeMembre);
    }

    /**
     * Renvoie la liste des espaces et rôles pour un code utilisateur et des groupes
     * @param userCode le code utilisateur
     * @param groupCodes la liste des groupes
     * @return la liste des espaces pour lesquels l'utilisateur est membre
     */
    public static Map<String, UserRolesCollaboratifBean> getRolesEspacesForUserAndGroup(String userCode, Vector<String> groupCodes) throws Exception {
        final Map<String, UserRolesCollaboratifBean> results = new HashMap<>();
        final UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao) ApplicationContextManager.getCoreContextBean(BasicDataSourceDAOManager.ID_BEAN,
            BasicDataSourceDAOManager.class).getDao(
            UserRolesCollaboratifBean.class);
        final List<UserRolesCollaboratifBean> userRoles = userRolesCollaboratifDao.getByCodeUser(userCode);
        for (UserRolesCollaboratifBean currentUserRoles : userRoles) {
            try (ContexteDao ctx = new ContexteDao()) {
                final Espacecollaboratif espace = new Espacecollaboratif();
                espace.setCtx(ctx);
                espace.setIdEspacecollaboratif(currentUserRoles.getIdCollaboratif());
                espace.retrieve();
                results.put(espace.getCode(), currentUserRoles);
            }
        }
        for (InfosEspaceCollaboratif espace : Espacecollaboratif.getListeEspaces()) {
            for (String codeGroupe : groupCodes) {
                final Collection<String> groupesMembres = Chaine.getVecteurAccolades(espace.getGroupesMembres());
                if (groupesMembres.contains(codeGroupe)) {
                    final UserRolesCollaboratifBean currentRoleEspace = new UserRolesCollaboratifBean();
                    currentRoleEspace.setCodeUser(userCode);
                    currentRoleEspace.setIdCollaboratif(espace.getId());
                    currentRoleEspace.setCodeRole(espace.getRolesMembre());
                    if (results.get(espace.getCode()) == null) {
                        results.put(espace.getCode(), currentRoleEspace);
                    }
                }
            }
        }
        return results;
    }

    /**
     * Détermine si l'utilisateur a un droit de consultation de cet espace.
     *
     * @param infosEspace l'espace concerné
     * @return true, si l'utilisateur peut consulter l'espace
     */
    public static boolean estVisiteurEspace(final ContexteUniv ctx, final InfosEspaceCollaboratif infosEspace) {
        boolean isVisitor = false;
        // TODO FBI : gérer la récursivité
        final TreeSet<String> groupesUtilisateur = ctx.getGroupesDsiAvecAscendants();
        final Vector<String> groupesConsultationEspace = Chaine.getVecteurAccolades(infosEspace.getGroupesConsultation());
        for (final String groupeUtilisateur : groupesUtilisateur) {
            if (groupesConsultationEspace.contains(groupeUtilisateur)) {
                isVisitor = true;
                break;
            }
        }
        return isVisitor;
    }

    /**
     * Détermine si l'utilisateur est membre de l'espace.
     *
     * @param infosEspace l'espace concerné
     * @return true, si l'utilisateur est membre de l'espace
     */
    public static boolean estMembreEspace(final ContexteUniv ctx, final InfosEspaceCollaboratif infosEspace) {
        boolean isMembre = false;
        final UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao) ApplicationContextManager.getCoreContextBean(BasicDataSourceDAOManager.ID_BEAN,
            BasicDataSourceDAOManager.class).getDao(
            UserRolesCollaboratifBean.class);
        try {
            final Espacecollaboratif espace = getEspace(infosEspace.getCode());
            final UserRolesCollaboratifBean membre = userRolesCollaboratifDao.getByCodeUserAndIdCollab(ctx.getCode(), espace.getIdEspacecollaboratif());
            if (membre != null) {
                isMembre = true;
            }
        } catch (Exception e) {
        }
        if (! isMembre) {
            final TreeSet<String> groupesUtilisateur = ctx.getGroupesDsiAvecAscendants();
            for (String groupeUtilisateur : groupesUtilisateur) {
                if (infosEspace.getGroupesMembres().contains(groupeUtilisateur)) {
                    isMembre = true;
                    break;
                }
            }
        }
        return isMembre;
    }

    /**
     * Inits the espace.
     */
    public void init() {
        setIdEspacecollaboratif(0L);
        setCode("");
        setActif("1");
        setInscriptionFront("1");
        setTheme("");
        setIntitule("");
        setCodeRubrique("");
        setCodeStructure("");
        setGroupesMembres("");
        setRolesMembre("");
        setDescription("");
        setInscriptionsEnCours("");
        setServices("");
        setDateCreation(new Date(System.currentTimeMillis()));
        setPeriodiciteNewsletter("0");
        setContenuNewsletter("");
        setDateDernierEnvoiNewsletter(new Date(0));
        setDateEnvoiNewsletter(new Date(0));
        setGroupesInscription("");
        setGroupesConsultation("");
        setLangue("0");
        setEnteteEspace("");
        setPiedEspace("");
    }

    /**
     * Récupère un espace par son code.
     *
     * @param codeEspace the code espace
     * @return the int
     * @throws Exception the exception
     */
    public int selectByCode(final String codeEspace) throws Exception {
        final ClauseWhere wherePourInscription = new ClauseWhere();
        if (StringUtils.isNotEmpty(codeEspace)) {
            wherePourInscription.and(ConditionHelper.egalVarchar("CODE", codeEspace));
        }
        return select(wherePourInscription.formaterSQL());
    }

    /**
     * Gets the theme.
     *
     * @return Returns the theme.
     * @throws Exception the exception
     */
    public String getLibelleTheme(Locale locale) throws Exception {
        return Libelle.getLibelle("0110", getTheme(), locale);
    }

    /**
     * Checks if is actif.
     *
     * @return true, if is actif
     */
    public boolean isActif() {
        return "1".equals(getActif());
    }

    @Override
    public Espacecollaboratif clone() throws CloneNotSupportedException {
        return (Espacecollaboratif) super.clone();
    }
}
