/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.collaboratif.om;

import java.io.File;

import com.univ.collaboratif.sgbd.FichiergwDB;
import com.univ.objetspartages.util.RessourceUtil;

/**
 * The Class Fichiergw.
 * 
 * @author romain
 * 
 *         To change the template for this generated type comment go to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Fichiergw extends FichiergwDB implements Cloneable {

	/** The PAT h_ servle t_ lectur e_ fichier. */
	public static String PATH_SERVLET_LECTURE_FICHIER = "/servlet/com.univ.collaboratif.utils.LectureFichiergw";

	/** The ETA t_ sauvegard e_ structur e_ courante. */
	public static String ETAT_SAUVEGARDE_STRUCTURE_COURANTE = "destruction_sauvegarde_courante";

	/**
	 * Instantiates a new fichiergw.
	 */
	public Fichiergw() {
		super();
	}

	/**
	 * Initialisation de l'objet.
	 */
	public void init() {
		setIdFichiergw((long) 0);
		setCodeParent("");
		setCode("");
		setTypeFichier("");
		setIdPhoto("");
		setIdVignette("");
		setPathFichierJoint("");
		setFormatFichierJoint("");
		setPoidsFichierJoint("");
		setNomFichierJoint("");
		setLibelleFichierJoint("");
		setNumeroVersion("");
		setDateVersion(new java.sql.Date(0));
		setCommentaireVersion("");
		setAuteurVersion("");
		setEtat("");
	}

	/**
	 * Gets the path absolu.
	 * 
	 * @return le path physique absolu du fichier
	 */
	public String getPathAbsolu() {
		return RessourceUtil.getAbsolutePath() + File.separatorChar + getPathFichierJoint();
	}
}
