/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.filtre;

import static org.apache.commons.lang3.StringUtils.containsIgnoreCase;

import org.apache.commons.collections.Predicate;

import com.univ.datagrid.bean.ResultatFicheDatagrid;

/**
 * Retourne un objet permettant de vérifier si un bean {@link ResultatFicheDatagrid} contient le terme fourni via {@link FiltreFicheUniv#critere} dans un de ses champs
 * 
 * @author olivier.camon
 * 
 */
public class FiltreFicheUniv implements Predicate {

	private final String critere;

	public FiltreFicheUniv(final String critere) {
		this.critere = critere;
	}

	@Override
	public boolean evaluate(final Object object) {
		boolean isARetourner = Boolean.FALSE;
		if (object instanceof ResultatFicheDatagrid) {
			final ResultatFicheDatagrid resultat = (ResultatFicheDatagrid) object;
			isARetourner = containsIgnoreCase(resultat.getLibelle(), critere);
			isARetourner = isARetourner || containsIgnoreCase(resultat.getTypeObjet(), critere) || containsIgnoreCase(resultat.getRubrique(), critere);
			isARetourner = isARetourner || containsIgnoreCase(resultat.getLangue(), critere) || containsIgnoreCase(resultat.getEtatFiche(), critere);
		}
		return isARetourner;
	}
}
