/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.processus;

import static org.apache.commons.lang3.StringUtils.containsIgnoreCase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.extension.module.composant.ComposantGroupe;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatGroupeDSI;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;

public class GroupeDSIDatagrid extends AbstractServiceDatagrid {

	private static final Logger LOG = LoggerFactory.getLogger(GroupeDSIDatagrid.class);

	public static final String ID_BEAN = "groupeDSIDatagrid";

	@Override
	public List<ResultatDatagrid> traiterRechercheDepuisRequete(final HttpServletRequest req) {
		final AutorisationBean autorisations = (AutorisationBean) SessionUtil.getInfosSession(req).get(SessionUtilisateur.AUTORISATIONS);
		if (isPermissionNonValide(autorisations)) {
			return Collections.<ResultatDatagrid> emptyList();
		}
		List<ResultatDatagrid> resultats = null;
		final Groupedsi groupedsi = new Groupedsi();
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		groupedsi.setCtx(ctx);
		try {
			groupedsi.select(req.getParameter("CODE"), req.getParameter("TYPE"), req.getParameter("LIBELLE"), req.getParameter("CODE_STRUCTURE"), StringUtils.EMPTY);
			resultats = mapperResultatRechercheDepuisRubrique(groupedsi);
		} catch (final Exception e) {
			LOG.error("impossible de récuperer les resultats de la recherche", e);
		}
		if (resultats == null) {
			resultats = Collections.<ResultatDatagrid> emptyList();
		}
		return resultats;
	}

	private boolean isPermissionNonValide(final AutorisationBean autorisations) {
		return autorisations == null || !autorisations.isWebMaster() && !autorisations.possedePermission(ComposantGroupe.getPermissionGestion());
	}

	private List<ResultatDatagrid> mapperResultatRechercheDepuisRubrique(final Groupedsi groupedsi) throws Exception {
		final List<ResultatDatagrid> resultats = new ArrayList<>();
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		ctx.getAutorisation();
		while (groupedsi.nextItem()) {
			final ResultatGroupeDSI res = new ResultatGroupeDSI();
			res.setLibelle(groupedsi.getLibelle());
			res.setTypeGroupe(Libelle.getLibelle("11", groupedsi.getType(), ctx.getLocale()));
			res.setStructure(Structure.getLibelleAffichable(groupedsi.getCodeStructure(), ctx.getLangue()));
			res.setUrlModification(DatagridUtils.getUrlActionGroupeDSI(String.valueOf(groupedsi.getIdGroupedsi()), "MODIFIERPARID"));
			res.setUrlSuppression(DatagridUtils.getUrlActionGroupeDSI(String.valueOf(groupedsi.getIdGroupedsi()), "SUPPRIMERPARID"));
			resultats.add(res);
		}
		return resultats;
	}

	@Override
	protected Predicate retrouvePredicate(final String critereRecherche) {
		return new Predicate() {

			@Override
			public boolean evaluate(final Object object) {
				boolean isARetourner = Boolean.FALSE;
				if (object instanceof ResultatGroupeDSI) {
					final ResultatGroupeDSI groupes = (ResultatGroupeDSI) object;
					isARetourner = containsIgnoreCase(groupes.getLibelle(), critereRecherche) || containsIgnoreCase(groupes.getTypeGroupe(), critereRecherche) || containsIgnoreCase(
						groupes.getStructure(), critereRecherche);
				}
				return isARetourner;
			}
		};
	}
}
