/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.processus;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.filtre.FiltreFicheUniv;
import com.univ.datagrid.servlet.LienPopupServlet;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.DateUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.SessionUtil;
import com.univ.utils.recherche.RechercheMultificheHelper;
import com.univ.utils.recherche.ResultatRechercheMultifiche;

public class MultiFicheToolboxDatagrid extends AbstractServiceDatagrid {

	/** l'id Spring du bean. */
	public static final String ID_BEAN = "multiFicheToolboxDatagrid";

	private static Logger LOG = LoggerFactory.getLogger(MultiFicheToolboxDatagrid.class);

	@Override
	public List<ResultatDatagrid> traiterRechercheDepuisRequete(final HttpServletRequest req) {
		final AutorisationBean autorisations = (AutorisationBean) SessionUtil.getInfosSession(req).get(SessionUtilisateur.AUTORISATIONS);
		if (autorisations == null) {
			return Collections.<ResultatDatagrid> emptyList();
		}
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		final String libelle = req.getParameter("TITRE");
		final String codeObjet = req.getParameter("CODE_OBJET");
		final String codeRubrique = req.getParameter("CODE_RUBRIQUE_RECHERCHE");
		final String codeRattachement = req.getParameter("CODE_RATTACHEMENT");
		final String codeRedacteur = req.getParameter("CODE_REDACTEUR");
		final String idMeta = req.getParameter("ID_META");
		final String urlFiche = req.getParameter("URL_FICHE");
		final String langue = req.getParameter("LANGUE");
		final String etatObjet = EtatFiche.EN_LIGNE.getEtat();
		// Récupération des critère de recherche de date
		final Date dateDebutCreation = recupererAttributDate(req, "DATE_CREATION_DEBUT");
		final Date dateFinCreation = recupererAttributDate(req, "DATE_CREATION_FIN");
		final Date dateDebutModification = recupererAttributDate(req, "DATE_MODIFICATION_DEBUT");
		final Date dateFinModification = recupererAttributDate(req, "DATE_MODIFICATION_FIN");
		final Date dateDebutMiseEnLigne = recupererAttributDate(req, "DATE_MISE_EN_LIGNE_DEBUT");
		final Date dateFinMiseEnLigne = recupererAttributDate(req, "DATE_MISE_EN_LIGNE_FIN");
		ResultatRechercheMultifiche resultatRechercheMultifiche = null;
		List<ResultatDatagrid> resultats = null;
		try {
			resultatRechercheMultifiche = RechercheMultificheHelper.rerchercherParmisToutesLesFiches(ctx, autorisations, libelle, codeObjet, "", codeRubrique, codeRattachement,
				codeRedacteur, idMeta, urlFiche, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne, langue,
				etatObjet, String.valueOf(DatagridUtils.getNombreMaxDatagrid()));
			resultats = mapperResultatRechercheDepuisMeta(resultatRechercheMultifiche.getResultats());
		} catch (final Exception e) {
			LOG.error("impossible d'executer la recherche", e);
			resultats = Collections.<ResultatDatagrid> emptyList();
		}
		return resultats;
	}

	private Date recupererAttributDate(final HttpServletRequest req, final String nomAttribut) {
		Date dateDepuisRequete = null;
		try {
			dateDepuisRequete = DateUtil.parseDate(req.getParameter(nomAttribut));
			if (!Formateur.estSaisie(dateDepuisRequete)) {
				dateDepuisRequete = null;
			}
		} catch (final Exception e) {}
		return dateDepuisRequete;
	}

	public static List<ResultatDatagrid> mapperResultatRechercheDepuisMeta(final Collection<Metatag> metatags) {
		final List<ResultatDatagrid> resultats = new ArrayList<>();
		for (final Metatag leMeta : metatags) {
			final ResultatFicheDatagrid resultat = new ResultatFicheDatagrid();
			resultat.setLibelle(leMeta.getMetaLibelleFiche());
			try {
				resultat.setRubrique((Rubrique.getIntitule(leMeta.getMetaCodeRubrique())));
			} catch (final Exception e) {
				LOG.error("impossible de calculer l'intitule de rubrique", e);
			}
			resultat.setLangue(LangueUtil.getLocale(leMeta.getMetaLangue()).getLanguage());
			resultat.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(leMeta.getMetaLangue()));
			resultat.setTypeObjet(ReferentielObjets.getLibelleObjet(leMeta.getMetaCodeObjet()));
			final StringBuilder lienToolbox = new StringBuilder(LienPopupServlet.LIEN_SERVLET).append("?");
			lienToolbox.append(LienPopupServlet.CODE_OBJET).append("=").append(leMeta.getMetaCode()).append("&amp;");
			lienToolbox.append(LienPopupServlet.TYPE_OBJET).append("=").append(ReferentielObjets.getNomObjet(leMeta.getMetaCodeObjet())).append("&amp;");
			lienToolbox.append(LienPopupServlet.LANGUE).append("=").append(leMeta.getMetaLangue()).append("&amp;");
			lienToolbox.append(LienPopupServlet.LIBELLE).append("=").append(EscapeString.escapeURL(leMeta.getMetaLibelleFiche()));
			resultat.setUrl(lienToolbox.toString());
			resultats.add(resultat);
		}
		return resultats;
	}

	@Override
	protected Predicate retrouvePredicate(final String critereRecherche) {
		return new FiltreFicheUniv(critereRecherche);
	}
}
