/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.processus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.multisites.InfosSite;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.UrlManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.SessionUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;

public class RattachementPrincipalDatagrid extends AbstractServiceDatagrid {

    private static final Logger LOG = LoggerFactory.getLogger(RattachementPrincipalDatagrid.class);

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisMeta(final Metatag leMeta) throws Exception {
        final List<ResultatDatagrid> resultats = new ArrayList<>();
        final InfosSite siteCourant = ContexteUtil.getContexteUniv().getInfosSite();
        final Map<String, String> libellesParEtat = ReferentielObjets.getEtatsObjet();
        final Map<String, String> classParEtat = FicheUnivHelper.getClassEtatsObjet();
        while (leMeta.nextItem()) {
            final ResultatFicheDatagrid resultat = new ResultatFicheDatagrid();
            resultat.setFilAriane(Rubrique.getFilAriane(leMeta.getMetaCodeRubrique(), ">"));
            resultat.setRubrique((Rubrique.getIntitule(leMeta.getMetaCodeRubrique())));
            final FicheUniv fiche = FicheUnivMgr.init(leMeta);
            if (fiche != null) {
                resultat.setId(leMeta.getIdMetatag());
                final AutorisationBean autorisations = ContexteUtil.getContexteUniv().getAutorisation();
                if (autorisations != null && autorisations.estAutoriseAModifierLaFiche(fiche)) {
                    final String url = DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "MODIFIER");
                    resultat.setUrlModification(URLResolver.getAbsoluteBoUrl(url, siteCourant));
                }
                if (autorisations != null && autorisations.estAutoriseASupprimerLaFiche(fiche) && !EtatFiche.A_SUPPRIMER.getEtat().equals(leMeta.getMetaEtatObjet())) {
                    final String url = DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "SUPPRIMER");
                    resultat.setUrlSuppression(URLResolver.getAbsoluteBoUrl(url, siteCourant));
                }
                resultat.setLibelle(leMeta.getMetaLibelleFiche());
                resultat.setEtatFiche(libellesParEtat.get(leMeta.getMetaEtatObjet()));
                resultat.setClassEtatFiche(classParEtat.get(leMeta.getMetaEtatObjet()));
                resultat.setLangue(LangueUtil.getLocale(leMeta.getMetaLangue()).getLanguage());
                resultat.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(leMeta.getMetaLangue()));
                resultat.setTypeObjet(ReferentielObjets.getLibelleObjet(leMeta.getMetaCodeObjet()));
                resultat.setDateModification(new Date(leMeta.getMetaDateModification().getTime()));
                if (EtatFiche.EN_LIGNE.getEtat().equals(leMeta.getMetaEtatObjet())) {
                    resultat.setUrl(URLResolver.getAbsoluteBoUrl(UrlManager.calculerUrlFiche(leMeta), siteCourant));
                }
                resultats.add(resultat);
            }
        }
        return resultats;
    }

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(final HttpServletRequest req) {
        final AutorisationBean autorisations = (AutorisationBean) SessionUtil.getInfosSession(req).get(SessionUtilisateur.AUTORISATIONS);
        if (autorisations == null || !autorisations.isAdministrateurRubrique()) {
            return Collections.emptyList();
        }
        final ContexteUniv ctx = ContexteUtil.getContexteUniv();
        final String codeRubrique = StringUtils.defaultString(req.getParameter("CODE_RUBRIQUE"));
        // Récupération des critère de recherche de date
        List<ResultatDatagrid> resultats = null;
        try {
            final RequeteSQL requeteSelect = new RequeteSQL();
            final ClauseWhere where = new ClauseWhere();
            where.and(ConditionHelper.egalVarchar("T1.META_CODE_RUBRIQUE", codeRubrique));
            requeteSelect.where(where);
            requeteSelect.limit(LimitHelper.ajouterCriteresLimitesEtOptimisation(ctx, 0, DatagridUtils.getNombreMaxDatagrid()));
            final Metatag meta = new Metatag();
            meta.init();
            meta.setCtx(ctx);
            meta.select(requeteSelect.formaterRequete());
            resultats = mapperResultatRechercheDepuisMeta(meta);
        } catch (final Exception e) {
            LOG.error("impossible d'executer la recherche", e);
            resultats = Collections.emptyList();
        }
        return resultats;
    }
}
