/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.processus;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.univ.datagrid.bean.CriteresDatagrid;
import com.univ.datagrid.bean.ResultatDatagrid;

public interface ServiceDatagrid {

	/**
	 * Permet de traiter les critères de recherche reçu depuis un datagrid
	 * 
	 * @param req
	 * @return
	 */
	public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req);

	/**
	 * Permet de traiter des actions d'un datagrid (suppression de masse, archivage...)
	 * 
	 * @param parametresDeLaRequete
	 */
	public void traiterAction(final HttpServletRequest req);

	/**
	 * Depuis la liste fourni en paramètre, on vérifie que les champs des résultats contienent le critère de recherche saisie par l'utilisateur et on ne retourne que ceux qui
	 * l'ont.
	 * 
	 * 
	 * @param resultats
	 * @param criteres
	 * @return
	 */
	public List<ResultatDatagrid> filtrerResultats(List<ResultatDatagrid> resultats, final CriteresDatagrid criteres);

	/**
	 * La liste est trié en fonction de la colonne choisi et du sens de trie.
	 * 
	 * @param resultats
	 * @param criteres
	 */
	public void trierResultats(final List<ResultatDatagrid> resultats, final CriteresDatagrid criteres);

	public List<ResultatDatagrid> postTraitementResultat(List<ResultatDatagrid> resultats);
}
