/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.lang.CharEncoding;
import com.univ.datagrid.bean.CriteresDatagrid;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.cache.CacheDatagridManager;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridManager;
import com.univ.datagrid.utils.DatagridUtils;

/**
 * Servlet permettant de gérer les interactions avec le datagrid : recherche/actions de masse et d'orienter vers le bon composant pour réaliser les opérations.
 * 
 * @author olivier.camon
 * 
 */
public class DatagridServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5619243850749934120L;

	@Override
	protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
		final AbstractServiceDatagrid gestionDatagrid = DatagridManager.getGestionDatagrid(req.getParameter(DatagridUtils.PARAM_BEAN_DATAGRID));
		final String idRequete = req.getParameter(DatagridUtils.PARAM_ID_REQUETE);
		List<ResultatDatagrid> resultats = Collections.emptyList();
		int total = 0;
		int totalAAfficher = 0;
		final CriteresDatagrid criteres = CriteresDatagrid.getCritereDepuisRequete(req);
		if (gestionDatagrid != null) {
			final String action = req.getParameter("ACTION");
			final CacheDatagridManager cacheDatagridManager = (CacheDatagridManager) ApplicationContextManager.getCoreContextBean(CacheDatagridManager.ID_BEAN);
			if (StringUtils.isNotBlank(action)) {
				cacheDatagridManager.flush(idRequete);
				gestionDatagrid.traiterAction(req);
			} else {
				resultats = cacheDatagridManager.traiterRecherche(idRequete, gestionDatagrid, req);
				gestionDatagrid.trierResultats(resultats, criteres);
				total = resultats.size();
				resultats = gestionDatagrid.filtrerResultats(resultats, criteres);
				totalAAfficher = resultats.size();
				resultats = DatagridUtils.paginerResultats(resultats, criteres);
				resultats = gestionDatagrid.postTraitementResultat(resultats);
			}
		}
		resp.setContentType("application/json");
		resp.setCharacterEncoding(CharEncoding.DEFAULT);
		resp.getWriter().write(DatagridUtils.mapperResultatEnJSON(resultats, total, totalAAfficher, criteres));
	}
}
