/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.servlet;

import java.io.IOException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.FicheUnivMgr;

/**
 * FIXME Servlet à revoir, c'est +/- un copier coller de ce qu'il y avait dans les JSP
 *
 * @author olivier.camon
 *
 */
public class LienPopupServlet extends HttpServlet {

	public static final String LIEN_SERVLET = "/servlet/com.kportal.servlet.LienPopupServlet";

	/**
	 *
	 */
	private static final long serialVersionUID = -7317972252389032829L;

	public static final String CODE_OBJET = "CODE";

	public static final String TYPE_OBJET = "OBJET";

	public static final String LANGUE = "LANGUE";

	public static final String LIBELLE = "LIBELLE";

	public static final String TYPE_TOOLBOX = "TOOLBOX";

	public static final String TYPE_LISTE = "LISTE";

	public static final String URL = "URL";

	private static final Logger LOG = LoggerFactory.getLogger(LienPopupServlet.class);

	@Override
	protected void doGet(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
		final String typeToolbox = req.getParameter(TYPE_TOOLBOX);
		final String typeListe = req.getParameter(TYPE_LISTE);
		final String url = req.getParameter(URL);
		final String codeObjet = StringUtils.defaultString(req.getParameter(CODE_OBJET));
		final String typeObjet = StringUtils.defaultString(req.getParameter(TYPE_OBJET));
		final String langue = StringUtils.defaultString(req.getParameter(LANGUE));
		String reponse = StringUtils.EMPTY;
		if ("MAILTO".equals(typeToolbox)) {
			reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_mailto.jsp";
		} else if (StringUtils.isNotBlank(url) && !"LIEN_INTERNE_JOINTURE".equals(typeToolbox) && !"LIEN_INTERNE_PAGE_TETE".equals(typeToolbox)) {
			reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_lien.jsp";
		} else {
			if ("PARCOURS".equals(typeListe)) {
				reponse = WebAppUtil.SG_PATH + "?EXT=offreformation&PROC=TRAITEMENT_PARCOURS&ACTION=AJOUTER&CODE_UEUP=" + codeObjet + ",LANGUE=" + langue + "&TOOLBOX=true";
			} else if ("RESPONSABLE".equals(typeListe)) {
				reponse = WebAppUtil.SG_PATH + "?EXT=offreformation&PROC=TRAITEMENT_RESPONSABLE&ACTION=AJOUTER&CODE_RESPONSABLE=" + codeObjet + ",LANGUE=" + langue;
			} else if ("DIPLOME".equals(typeListe) || "FORMATION".equals(typeListe)) {
				reponse = WebAppUtil.SG_PATH + "?EXT=offreformation&PROC=TRAITEMENT_DIPLOME&ACTION=AJOUTER&CODE_FORMATION=" + codeObjet + ",LANGUE=" + langue + "&&LISTE=" + typeListe;
			} else {
				FicheUniv fiche = null;
				Metatag meta = null;
				try {
					fiche = FicheUnivHelper.getFiche(typeObjet, codeObjet, langue);
					meta = FicheUnivMgr.lireMeta(fiche);
				} catch (final Exception e) {
					LOG.error("impossible de récuperer la fiche", e);
				}
				if (isChoixRubriqueForcage(fiche, typeToolbox)) {
					reponse = "/adminsite/toolbox/choix_rubrique_forcage.jsp";
				} else if ("LIEN_INTERNE".equals(typeToolbox)) {
					reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_interne.jsp";
				} else if ("LIEN_INTRANET".equals(typeToolbox)) {
					reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_intranet.jsp";
				} else if ("LIEN_RECHERCHE".equals(typeToolbox)) {
					reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_recherche.jsp";
				} else if ("LIEN_INTERNE_PLUGIN".equals(typeToolbox)) {
					// pour les jointures de fiche sur un plugin (ex: commentaire) on remplace le code par l'id du meta
					reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_generique.jsp?" + CODE_OBJET + "=" + meta.getIdMetatag();
				} else {
					// pour les jointures entre fiche, on renvoit code,LANGUE=langue
					reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_generique.jsp?" + CODE_OBJET + "=" + codeObjet + ",LANGUE=" + langue + (typeToolbox.endsWith("PAGE_TETE") ? ",TYPE=" + typeObjet : "");
				}
			}
		}
		getServletContext().getRequestDispatcher(reponse).forward(req, res);
	}

	private boolean isChoixRubriqueForcage(final FicheUniv fiche, final String typeToolbox) {
		Vector<String> rubriquesPublication = null;
		try {
			rubriquesPublication = Rubriquepublication.getListeRubriquesPublication(ContexteUtil.getContexteUniv(), fiche);
		} catch (final Exception e) {
			LOG.error("impossible de récuperer les rubriques de publication de la fiche", e);
		}
		return CollectionUtils.isNotEmpty(rubriquesPublication) && !"LIEN_INTERNE_PAGE_TETE".equals(typeToolbox) && !"LIEN_INTERNE_JOINTURE".equals(typeToolbox);
	}
}
