/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.datagrid.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.Metatag;
import com.univ.url.UrlManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;

public class VoirFicheEnLigneServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6232012835398251982L;

	private static final String PARAM_OBJET = "OBJET";

	private static final String PARAM_ID_FICHE = "ID_FICHE";

	private static final Logger LOG = LoggerFactory.getLogger(VoirFicheEnLigneServlet.class);

	@Override
	protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
		final String idFiche = req.getParameter(PARAM_ID_FICHE);
		final String codeObjet = req.getParameter(PARAM_OBJET);
		if (StringUtils.isNotBlank(idFiche) && StringUtils.isNumeric(idFiche) && StringUtils.isNotBlank(codeObjet)) {
			final Metatag metaCourant = new Metatag();
			final ContexteUniv ctx = ContexteUtil.getContexteUniv();
			metaCourant.setCtx(ctx);
			try {
				metaCourant.select(codeObjet, Long.valueOf(idFiche));
				metaCourant.nextItem();
				if (EtatFiche.EN_LIGNE.getEtat().equals(metaCourant.getMetaEtatObjet())) {
					final String url = URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(metaCourant), ctx);
					resp.sendRedirect(url);
				}
			} catch (final Exception e) {
				LOG.error("impossible de récupérer l'url de la fiche d'id " + idFiche + " et de type " + codeObjet);
				throw new ServletException(e);
			}
		}
	}
}
