/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.identity.bean;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.annotate.JsonTypeInfo.As;
import org.codehaus.jackson.annotate.JsonTypeInfo.Id;
import org.codehaus.jackson.map.annotate.JsonView;

import com.univ.utils.json.Views;

@JsonTypeInfo(use = Id.CLASS, include = As.PROPERTY, property = "class")
public class IdentityBean {

	@JsonView(Views.FrontOfficeView.class)
	protected Long id = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String civilite = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String nom = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String prenom = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String adresse = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String codePostal = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String ville = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String pays = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String telephone = null;

	@JsonView(Views.FrontOfficeView.class)
	protected String email = null;

	@JsonIgnore
	protected String data = null;

	protected String jspComplementFragment = null;

	public void init(IdentityBean bean) {
		this.id = bean.id;
		this.civilite = bean.civilite;
		this.nom = bean.nom;
		this.prenom = bean.prenom;
		this.adresse = bean.adresse;
		this.codePostal = bean.codePostal;
		this.ville = bean.ville;
		this.pays = bean.pays;
		this.telephone = bean.telephone;
		this.email = bean.email;
		this.data = bean.data;
		this.jspComplementFragment = bean.jspComplementFragment;
	}

	public void setIdIdentity(Long idIndentity) {
		this.id = idIndentity;
	}

	public Long getIdIdentity() {
		return id;
	}

	public void setCivilite(String civilite) {
		this.civilite = civilite;
	}

	public String getCivilite() {
		return civilite;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}

	public String getNom() {
		return nom;
	}

	public void setPrenom(String prenom) {
		this.prenom = prenom;
	}

	public String getPrenom() {
		return prenom;
	}

	public void setAdresse(String adresse) {
		this.adresse = adresse;
	}

	public String getAdresse() {
		return adresse;
	}

	public void setCodePostal(String codePostal) {
		this.codePostal = codePostal;
	}

	public String getCodePostal() {
		return codePostal;
	}

	public void setVille(String ville) {
		this.ville = ville;
	}

	public String getVille() {
		return ville;
	}

	public void setPays(String pays) {
		this.pays = pays;
	}

	public String getPays() {
		return pays;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getEmail() {
		return email;
	}

	public void setData(String data) {
		this.data = data;
	}

	public String getData() {
		return data;
	}

	public String getJspComplementFragment() {
		return jspComplementFragment;
	}

	public void setJspComplementFragment(String jspComplementFragment) {
		this.jspComplementFragment = jspComplementFragment;
	}
}
