/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.identity.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;

public abstract class AbstractIdentityProcess extends ProcessusBean {

	protected boolean proceed = true;

	public AbstractIdentityProcess(InfoBean infoBean) {
		super(infoBean);
	}

	@Override
	/**
	 * Point d'entree du processus.
	 */
	public boolean traiterAction() throws Exception {
		action = infoBean.getString("ACTION");
		try {
			if ("INSCRIRE".equals(action)) {
				preparerSaisie();
			} else {
				gererActions();
			}
		} catch (Exception e) {
			infoBean.addMessageErreur(e.toString());
		}
		//placer l'état dans le composant d'infoBean
		infoBean.setEcranLogique(ecranLogique);
		return (etat == FIN);
	}

	protected void gererActions() throws Exception {
		if (InfoBean.ACTION_ENREGISTRER.equals(action)) {
			if (proceed) {
				preTraiterEnregistrer();
			}
			if (proceed) {
				traiterEnregistrer();
			}
			if (proceed) {
				postTraiterEnregistrer();
			}
		}
	}

	// Action par défaut
	protected abstract void preparerSaisie() throws Exception;

	// Action enregitrer
	protected void preTraiterEnregistrer() throws Exception {};

	protected abstract void traiterEnregistrer() throws Exception;

	protected void postTraiterEnregistrer() throws Exception {};
}
