/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.AbstractCacheManager;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteDao;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Component
public class CacheMediaManager extends AbstractCacheManager{

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "cacheMediaManager";

	private static final Logger LOGGER = LoggerFactory.getLogger(CacheMediaManager.class);

	public static final String KEY_CACHE = "CacheMediaManager.cacheRubriqueBySource";

	public static CacheMediaManager getInstance(){
		return (CacheMediaManager) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

	private HashMap<String, String> getRubriqueBySource() throws Exception{
		final HashMap<String, String> res = new HashMap<String, String>();
		try (ContexteDao ctx = new ContexteDao()) {
			final Media media = new Media();
			media.init();
			media.setCtx(ctx);
			media.select("WHERE CODE_RUBRIQUE!=''");
			while (media.nextItem()) {
				if (media.isLocal()) {
					res.put(media.getUrl(), media.getCodeRubrique());
				}
			}
		} catch (final Exception e) {
			throw new Exception("Erreur de chargement des médias rubriqués",e);
		}
		LOGGER.info("Chargement de " + res.size() + " médias rubriqués OK");
		return res;
	}

	public String getCodeRubrique(String sUrl) {
		Object object = call();
		if (object!=null){
			return ((HashMap<String, String>)object).get(sUrl);
		}
		return null;
	}

	public void refresh(Media media, boolean async) {
		String old = (media!=null?getCodeRubrique(media.getUrl()):null);
		if (media == null || ((StringUtils.isNotEmpty(old) || StringUtils.isNotEmpty(media.getCodeRubrique()) ) &&  !media.getCodeRubrique().equals(old))){
			if (async){
				getInstance().asyncRefresh();
			}else{
				getInstance().refresh();
			}
		}
	}

	@Override
	public Object getObjectToCache() throws Exception {
		return getRubriqueBySource();
	}

	@Override
	public String getCacheName() {
		return KEY_CACHE;
	}

	@Override
	public Object getObjectKey() {
		return KEY_CACHE;
	}

}
