/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque;

public class DailyMotionUrl implements SpecificUrl {

	private static String URL_SOURCE = "//www.dailymotion.com/embed/video/";

	private static String TYP_RESSOURCE = "video";

	@Override
	public String processUrl(String url) throws Exception {
		// url entrée http://www.dailymotion.com/featured/video/x35714_cap-nord-projet-1_creation
		// url sortie http://www.dailymotion.com/swf/x35714
		String res = url;
		String codeVideo = "";
		if (url.indexOf("/") != -1) {
			url = url.substring(url.lastIndexOf("/") + 1, url.length());
		}
		if (url.indexOf("_") != -1) {
			codeVideo = url.substring(0, url.indexOf("_"));
			res = URL_SOURCE + codeVideo;
		}
		return res;
	}

	@Override
	public String getTypeRessource() {
		return TYP_RESSOURCE;
	}

	@Override
	public String getUrlSource() {
		return URL_SOURCE;
	}
}
