/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque;

import org.apache.commons.lang3.StringUtils;

public class ShortYouTubeUrl implements SpecificUrl {

	private static String URL_SOURCE = "//www.youtube.com/embed/";

	private static String TYP_RESSOURCE = "video";

	@Override
	public String processUrl(final String url) throws Exception {
		// Url entrée http://www.youtu.be/auRo72Yg5YE
		// Url sortie http://www.youtube.com/embed/auRo72Yg5YE
		String codeVideo = StringUtils.substringAfter(url, "youtu.be/");
		codeVideo = StringUtils.substringBefore(codeVideo, "?");
		String res = url;
		if (StringUtils.isNotBlank(codeVideo)) {
			res = URL_SOURCE + codeVideo;
		}
		return res;
	}

	@Override
	public String getTypeRessource() {
		return TYP_RESSOURCE;
	}

	@Override
	public String getUrlSource() {
		return URL_SOURCE;
	}
}
