/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.container;

/**
 * Enumération des attributs de balise HTML.
 * 
 * @author pierre.cosson
 * 
 */
public enum AttributBaliseHTML {
	/**
	 * Evenement JS ONCLICK.
	 */
	ON_CLICK("onclick"),
	/**
	 * Evenement JS ONMOUSEOVER.
	 */
	ON_MOUVE_OVER("onmouseover"),
	/**
	 * Classe CSS
	 */
	CLASS("class"),
	/**
	 * attribut Style CSS
	 */
	STYLE("style"),
	/**
	 * attribut REL
	 */
	TITLE("title"),
	/**
	 * attribut href
	 */
	HREF("href");

	/**
	 * Libellé de l'événement
	 */
	private String libelle;

	/**
	 * Constructeur
	 * 
	 * @param libelle
	 *            libellé de l'évenement javascript
	 */
	private AttributBaliseHTML(String libelle) {
		this.libelle = libelle;
	}

	/**
	 * Récupérer le libellé de l'evenement javascript.
	 * 
	 * @return le libellé de l'événement directement insérable dans de l'HTML.
	 */
	public String getLibelle() {
		return this.libelle;
	}
}
