/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.container;

import java.util.Collection;
import java.util.List;

import com.univ.objetspartages.om.Media;

/**
 * Un {@link ClassifieurMedia} est un élement qui permet de classer, trier, les {@link Media} selon un critére afin de les afficher dans des {@link VisionneuseMultimedia}.
 * 
 * @author Pierre Cosson
 */
public interface ClassifieurMedia {

	/**
	 * Donner la liste d'élements de tri.
	 * 
	 * @param classifications
	 */
	void setClassifications(Collection<ClassificationMedia> classifications);

	/**
	 * On remplie les elements de tri avec les médias correspondant au critéres de classement.
	 * 
	 * @param medias
	 *            La liste des médias à classer dans les différents élements de classement.
	 * @return la liste des éléments de classement rempli de {@link Media}.
	 */
	Collection<ClassificationMedia> classifierMedias(List<Media> medias);
}
