/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.container;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import com.univ.objetspartages.om.Media;

/**
 * Ce classifieur permet de classer les {@link Media} selon leur type : video, audio, photo et fichier. <br/>
 * Les élements du JTF à définir :
 * <ul>
 * <li>mediatheque.classificateurParType.code. + CODE_CLASSIFICATION : ces elements servent à retrouver le type de ressources associé à la classification</li>
 * </ul>
 * 
 * @author Pierre Cosson
 */
public class ClassifieurParTypeDeMedia implements ClassifieurMedia {

	/** La liste des éléments de classification. */
	private Map<String, ClassificationMedia> classifications = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.mediatheque.container.ClassifieurMedia#setClassifications(
	 * java.util.Collection)
	 */
	@Override
	public void setClassifications(Collection<ClassificationMedia> classifications) {
		this.classifications = new TreeMap<String, ClassificationMedia>();
		String mediaType;
		ClassificationMedia classification;
		Iterator<ClassificationMedia> classificationsIt = classifications.iterator();
		while (classificationsIt.hasNext()) {
			classification = classificationsIt.next();
			mediaType = classification.getCodeClassification();
			this.classifications.put(mediaType, classification);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.kosmos.mediatheque.container.ClassifieurMedia#classifierMedias(java
	 * .util.List)
	 */
	@Override
	public Collection<ClassificationMedia> classifierMedias(List<Media> medias) {
		Media media;
		ClassificationMedia classification;
		this.initClassifications();
		for (int i = 0; i < medias.size(); i++) {
			media = medias.get(i);
			classification = this.classifications.get(media.getTypeRessource().toLowerCase());
			if (classification != null) {
				classification.addMedia(media);
			}
		}
		return this.classifications.values();
	}

	/**
	 * Initialiser tous les objets {@link ClassificationMedia} qui sont contenus dans l'instance.
	 */
	private void initClassifications() {
		Iterator<ClassificationMedia> classificationsIt = this.classifications.values().iterator();
		while (classificationsIt.hasNext()) {
			classificationsIt.next().init();
		}
	}
}
