/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.univ.objetspartages.om.Media;

public class LanceurMedia {

	private Media media;

	private Map<AttributBaliseHTML, List<String>> attributBaliseHTML;

	private List<String> htmlAvantLanceur;

	private List<String> htmlApresLanceur;

	private List<String> jsAvantLanceur;

	private List<String> jsApresLanceur;

	public LanceurMedia(Media media) {
		this.attributBaliseHTML = new HashMap<AttributBaliseHTML, List<String>>();
		this.htmlApresLanceur = new ArrayList<String>();
		this.htmlAvantLanceur = new ArrayList<String>();
		this.jsAvantLanceur = new ArrayList<String>();
		this.jsApresLanceur = new ArrayList<String>();
		this.media = media;
	}

	public void addAttributHTML(AttributBaliseHTML evenement, String action) {
		List<String> actionExistante = this.attributBaliseHTML.get(evenement);
		if (actionExistante == null) {
			actionExistante = new ArrayList<String>();
			this.attributBaliseHTML.put(evenement, actionExistante);
		}
		// si l'action n'a pas déjà été ajoutée
		if (!actionExistante.contains(action)) {
			actionExistante.add(action);
		}
	}

	public void addAttributHTMLPremier(AttributBaliseHTML evenement, String action) {
		List<String> actionExistante = this.attributBaliseHTML.get(evenement);
		if (actionExistante == null) {
			actionExistante = new ArrayList<String>();
			this.attributBaliseHTML.put(evenement, actionExistante);
		}
		// si l'action n'a pas déjà été ajoutée
		if (!actionExistante.contains(action)) {
			actionExistante.add(0, action);
		}
	}

	public void addHTMLAvantLanceur(String htmlAvantLanceur) {
		this.htmlAvantLanceur.add(htmlAvantLanceur);
	}

	public void addHTMLApresLanceur(String htmlApresLanceur) {
		this.htmlApresLanceur.add(htmlApresLanceur);
	}

	public void addJSAvantLanceur(String jsAvantLanceur) {
		if (!this.jsAvantLanceur.contains(jsAvantLanceur)) {
			this.jsAvantLanceur.add(jsAvantLanceur);
		}
	}

	public void addJSApresLanceur(String jsApresLanceur) {
		if (!this.jsApresLanceur.contains(jsApresLanceur)) {
			this.jsApresLanceur.add(jsApresLanceur);
		}
	}

	public Media getMedia() {
		return media;
	}

	public void setMedia(Media media) {
		this.media = media;
	}

	public String getHTMLAvantLanceur() {
		return this.listStringToString(this.htmlAvantLanceur);
	}

	public String getHTMLApresLanceur() {
		return this.listStringToStringInversee(this.htmlApresLanceur);
	}

	public String getJSAvantLanceur() {
		return this.listStringToString(this.jsAvantLanceur);
	}

	public String getJSApresLanceur() {
		return this.listStringToString(this.jsApresLanceur);
	}

	public String getValeurAttributHTML(AttributBaliseHTML evenement) {
		List<String> attributHTML = this.attributBaliseHTML.get(evenement);
		if (attributHTML != null && attributHTML.size() > 0) {
			return this.listStringToString(attributHTML);
		} else {
			return null;
		}
	}

	public Set<AttributBaliseHTML> getAttributsBaliseHTML() {
		return this.attributBaliseHTML.keySet();
	}

	private String listStringToString(List<String> liste) {
		StringBuilder returnString = new StringBuilder();
		for (String element : liste) {
			returnString.append(element);
		}
		return returnString.toString();
	}

	private String listStringToStringInversee(List<String> liste) {
		StringBuilder returnString = new StringBuilder();
		for (int i = (liste.size() - 1); i >= 0; i--) {
			returnString.append(liste.get(i));
		}
		return returnString.toString();
	}
}
